/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class ByteBufferUtils {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];

    public static ByteBuffer combine(Collection<ByteBuffer> bufs) {
        if (bufs == null || bufs.isEmpty()) {
            return EMPTY_BYTE_BUFFER;
        }
        int size = 0;
        boolean isDirect = false;
        for (ByteBuffer buf : bufs) {
            size += buf.remaining();
            isDirect = isDirect || buf.isDirect();
        }
        ByteBuffer combined = isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        for (ByteBuffer buf : bufs) {
            ByteBufferUtils.copyTo(buf, combined);
        }
        combined.flip();
        return combined;
    }

    public static long getUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)value);
    }

    public static int getUnsignedShort(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer buffer, int value) {
        buffer.putShort((short)value);
    }

    public static short getUnsignedByte(ByteBuffer buffer) {
        return (short)((short)buffer.get() & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer buffer, short value) {
        buffer.put((byte)value);
    }

    public static ByteBuffer view(ByteBuffer buffer, int offset, int length) {
        ByteBuffer view = buffer.slice();
        view.position(offset);
        int newLimit = Math.min(view.position() + length, view.capacity());
        view.limit(newLimit);
        return view.slice();
    }

    public static void copyTo(ByteBuffer src, byte[] dst) {
        ByteBuffer copy = src.duplicate();
        copy.get(dst);
    }

    public static void copyTo(ByteBuffer src, ByteBuffer dst) {
        ByteBuffer copy = src.duplicate();
        dst.put(copy);
    }

    public static SSLEngineResult encryptSSL(SSLEngine engine, Collection<ByteBuffer> buffers, ByteBuffer dest) throws SSLException {
        ByteBuffer[] src = buffers.isEmpty() ? EMPTY_BYTE_BUFFER_ARRAY : buffers.toArray(new ByteBuffer[buffers.size()]);
        return engine.wrap(src, dest);
    }
}

