/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.dledger;

import io.openmessaging.storage.dledger.DLedgerLeaderElector;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.dledger.DLedgerCommitLog;

public class DLedgerRoleChangeHandler
implements DLedgerLeaderElector.RoleChangeHandler {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("DLegerRoleChangeHandler_"));
    private BrokerController brokerController;
    private DefaultMessageStore messageStore;
    private DLedgerCommitLog dLedgerCommitLog;
    private DLedgerServer dLegerServer;

    public DLedgerRoleChangeHandler(BrokerController brokerController, DefaultMessageStore messageStore) {
        this.brokerController = brokerController;
        this.messageStore = messageStore;
        this.dLedgerCommitLog = (DLedgerCommitLog)messageStore.getCommitLog();
        this.dLegerServer = this.dLedgerCommitLog.getdLedgerServer();
    }

    public void handle(final long term, final MemberState.Role role) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    boolean succ = true;
                    log.info("Begin handling broker role change term={} role={} currStoreRole={}", new Object[]{term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole()});
                    switch (role) {
                        case CANDIDATE: {
                            if (DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE) break;
                            DLedgerRoleChangeHandler.this.brokerController.changeToSlave(DLedgerRoleChangeHandler.this.dLedgerCommitLog.getId());
                            break;
                        }
                        case FOLLOWER: {
                            DLedgerRoleChangeHandler.this.brokerController.changeToSlave(DLedgerRoleChangeHandler.this.dLedgerCommitLog.getId());
                            break;
                        }
                        case LEADER: {
                            while (true) {
                                if (!DLedgerRoleChangeHandler.this.dLegerServer.getMemberState().isLeader()) {
                                    succ = false;
                                    break;
                                }
                                if (DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getLedgerEndIndex() == -1L || DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getLedgerEndIndex() == DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getCommittedIndex() && DLedgerRoleChangeHandler.this.messageStore.dispatchBehindBytes() == 0L) break;
                                Thread.sleep(100L);
                            }
                            if (!succ) break;
                            DLedgerRoleChangeHandler.this.messageStore.recoverTopicQueueTable();
                            DLedgerRoleChangeHandler.this.brokerController.changeToMaster(BrokerRole.SYNC_MASTER);
                            break;
                        }
                    }
                    log.info("Finish handling broker role change succ={} term={} role={} currStoreRole={} cost={}", new Object[]{succ, term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole(), DLedgerUtils.elapsed((long)start)});
                }
                catch (Throwable t) {
                    log.info("[MONITOR]Failed handling broker role change term={} role={} currStoreRole={} cost={}", new Object[]{term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole(), DLedgerUtils.elapsed((long)start), t});
                }
            }
        };
        this.executorService.submit(runnable);
    }

    public void startup() {
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

