/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction.queue;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageServiceImpl;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class TransactionalOpBatchService
extends ServiceThread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private BrokerController brokerController;
    private TransactionalMessageServiceImpl transactionalMessageService;
    private long wakeupTimestamp = 0L;

    public TransactionalOpBatchService(BrokerController brokerController, TransactionalMessageServiceImpl transactionalMessageService) {
        this.brokerController = brokerController;
        this.transactionalMessageService = transactionalMessageService;
    }

    public String getServiceName() {
        return TransactionalOpBatchService.class.getSimpleName();
    }

    public void run() {
        LOGGER.info("Start transaction op batch thread!");
        long checkInterval = this.brokerController.getBrokerConfig().getTransactionOpBatchInterval();
        this.wakeupTimestamp = System.currentTimeMillis() + checkInterval;
        while (!this.isStopped()) {
            long interval = this.wakeupTimestamp - System.currentTimeMillis();
            if (interval <= 0L) {
                interval = 0L;
                this.wakeup();
            }
            this.waitForRunning(interval);
        }
        LOGGER.info("End transaction op batch thread!");
    }

    protected void onWaitEnd() {
        this.wakeupTimestamp = this.transactionalMessageService.batchSendOpMessage();
    }
}

