/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.BoundaryType;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.InFlightRequestFuture;
import org.apache.rocketmq.tieredstore.common.InFlightRequestKey;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.file.CompositeAccess;
import org.apache.rocketmq.tieredstore.file.TieredCommitLog;
import org.apache.rocketmq.tieredstore.file.TieredConsumeQueue;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class CompositeFlatFile
implements CompositeAccess {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected volatile boolean closed = false;
    protected int readAheadFactor;
    protected volatile long dispatchOffset;
    protected final ReentrantLock compositeFlatFileLock;
    protected final TieredMessageStoreConfig storeConfig;
    protected final TieredMetadataStore metadataStore;
    protected final String filePath;
    protected final TieredCommitLog commitLog;
    protected final TieredConsumeQueue consumeQueue;
    protected final Cache<String, Long> groupOffsetCache;
    protected final ConcurrentMap<InFlightRequestKey, InFlightRequestFuture> inFlightRequestMap;

    public CompositeFlatFile(TieredFileAllocator fileQueueFactory, String filePath) {
        this.filePath = filePath;
        this.storeConfig = fileQueueFactory.getStoreConfig();
        this.readAheadFactor = this.storeConfig.getReadAheadMinFactor();
        this.metadataStore = TieredStoreUtil.getMetadataStore(this.storeConfig);
        this.compositeFlatFileLock = new ReentrantLock();
        this.inFlightRequestMap = new ConcurrentHashMap<InFlightRequestKey, InFlightRequestFuture>();
        this.commitLog = new TieredCommitLog(fileQueueFactory, filePath);
        this.consumeQueue = new TieredConsumeQueue(fileQueueFactory, filePath);
        this.groupOffsetCache = this.initOffsetCache();
    }

    protected void recoverMetadata() {
        if (!this.consumeQueue.isInitialized() && this.dispatchOffset != -1L) {
            this.consumeQueue.setBaseOffset(this.dispatchOffset * 20L);
        }
    }

    private Cache<String, Long> initOffsetCache() {
        return Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
            if (cause.equals((Object)RemovalCause.EXPIRED)) {
                this.inFlightRequestMap.remove(new InFlightRequestKey((String)key));
            }
        }).build();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ReentrantLock getCompositeFlatFileLock() {
        return this.compositeFlatFileLock;
    }

    public long getCommitLogMinOffset() {
        return this.commitLog.getMinOffset();
    }

    public long getCommitLogMaxOffset() {
        return this.commitLog.getMaxOffset();
    }

    public long getCommitLogBeginTimestamp() {
        return this.commitLog.getBeginTimestamp();
    }

    public long getConsumeQueueBaseOffset() {
        return this.consumeQueue.getBaseOffset();
    }

    @Override
    public long getCommitLogDispatchCommitOffset() {
        return this.commitLog.getDispatchCommitOffset();
    }

    public long getConsumeQueueMinOffset() {
        return this.consumeQueue.getMinOffset() / 20L;
    }

    public long getConsumeQueueCommitOffset() {
        return this.consumeQueue.getCommitOffset() / 20L;
    }

    public long getConsumeQueueMaxOffset() {
        return this.consumeQueue.getMaxOffset() / 20L;
    }

    public long getConsumeQueueEndTimestamp() {
        return this.consumeQueue.getEndTimestamp();
    }

    public long getDispatchOffset() {
        return this.dispatchOffset;
    }

    @Override
    public CompletableFuture<ByteBuffer> getMessageAsync(long queueOffset) {
        return this.getConsumeQueueAsync(queueOffset).thenComposeAsync(cqBuffer -> {
            long commitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
            int length = CQItemBufferUtil.getSize(cqBuffer);
            return this.getCommitLogAsync(commitLogOffset, length);
        });
    }

    @Override
    public long getOffsetInConsumeQueueByTime(long timestamp, BoundaryType boundaryType) {
        Pair<Long, Long> pair = this.consumeQueue.getQueueOffsetInFileByTime(timestamp, boundaryType);
        long minQueueOffset = (Long)pair.getLeft();
        long maxQueueOffset = (Long)pair.getRight();
        if (maxQueueOffset == -1L || maxQueueOffset < minQueueOffset) {
            return -1L;
        }
        long low = minQueueOffset;
        long high = maxQueueOffset;
        long offset = 0L;
        ByteBuffer message = this.getMessageAsync(maxQueueOffset).join();
        long storeTime = MessageBufferUtil.getStoreTimeStamp(message);
        if (storeTime < timestamp) {
            switch (boundaryType) {
                case LOWER: {
                    return maxQueueOffset + 1L;
                }
                case UPPER: {
                    return maxQueueOffset;
                }
            }
            LOGGER.warn("CompositeFlatFile#getQueueOffsetByTime: unknown boundary boundaryType");
        }
        if ((storeTime = MessageBufferUtil.getStoreTimeStamp(message = this.getMessageAsync(minQueueOffset).join())) > timestamp) {
            switch (boundaryType) {
                case LOWER: {
                    return minQueueOffset;
                }
                case UPPER: {
                    return 0L;
                }
            }
            LOGGER.warn("CompositeFlatFile#getQueueOffsetByTime: unknown boundary boundaryType");
        }
        long midOffset = -1L;
        long targetOffset = -1L;
        long leftOffset = -1L;
        long rightOffset = -1L;
        while (high >= low) {
            midOffset = (low + high) / 2L;
            message = this.getMessageAsync(midOffset).join();
            storeTime = MessageBufferUtil.getStoreTimeStamp(message);
            if (storeTime == timestamp) {
                targetOffset = midOffset;
                break;
            }
            if (storeTime > timestamp) {
                high = midOffset - 1L;
                rightOffset = midOffset;
                continue;
            }
            low = midOffset + 1L;
            leftOffset = midOffset;
        }
        if (targetOffset != -1L) {
            offset = targetOffset;
            long previousAttempt = targetOffset;
            switch (boundaryType) {
                case LOWER: {
                    long attempt;
                    while ((attempt = previousAttempt - 1L) >= minQueueOffset && (storeTime = MessageBufferUtil.getStoreTimeStamp(message = this.getMessageAsync(attempt).join())) == timestamp) {
                        previousAttempt = attempt;
                    }
                    offset = previousAttempt;
                    break;
                }
                case UPPER: {
                    long attempt;
                    while ((attempt = previousAttempt + 1L) <= maxQueueOffset && (storeTime = MessageBufferUtil.getStoreTimeStamp(message = this.getMessageAsync(attempt).join())) == timestamp) {
                        previousAttempt = attempt;
                    }
                    offset = previousAttempt;
                    break;
                }
                default: {
                    LOGGER.warn("CompositeFlatFile#getQueueOffsetByTime: unknown boundary boundaryType");
                    break;
                }
            }
        } else {
            switch (boundaryType) {
                case LOWER: {
                    offset = rightOffset;
                    break;
                }
                case UPPER: {
                    offset = leftOffset;
                    break;
                }
                default: {
                    LOGGER.warn("CompositeFlatFile#getQueueOffsetByTime: unknown boundary boundaryType");
                }
            }
        }
        return offset;
    }

    @Override
    public void initOffset(long offset) {
        if (!this.consumeQueue.isInitialized()) {
            this.consumeQueue.setBaseOffset(offset * 20L);
        }
        this.dispatchOffset = offset;
    }

    @Override
    public AppendResult appendCommitLog(ByteBuffer message) {
        return this.appendCommitLog(message, false);
    }

    @Override
    public AppendResult appendCommitLog(ByteBuffer message, boolean commit) {
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        long queueOffset = MessageBufferUtil.getQueueOffset(message);
        if (this.dispatchOffset != queueOffset) {
            return AppendResult.OFFSET_INCORRECT;
        }
        AppendResult result = this.commitLog.append(message, commit);
        if (result == AppendResult.SUCCESS) {
            this.dispatchOffset = queueOffset + 1L;
        }
        return result;
    }

    @Override
    public AppendResult appendConsumeQueue(DispatchRequest request) {
        return this.appendConsumeQueue(request, false);
    }

    @Override
    public AppendResult appendConsumeQueue(DispatchRequest request, boolean commit) {
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        if (request.getConsumeQueueOffset() != this.getConsumeQueueMaxOffset()) {
            return AppendResult.OFFSET_INCORRECT;
        }
        return this.consumeQueue.append(request.getCommitLogOffset(), request.getMsgSize(), request.getTagsCode(), request.getStoreTimestamp(), commit);
    }

    @Override
    public CompletableFuture<ByteBuffer> getCommitLogAsync(long offset, int length) {
        return this.commitLog.readAsync(offset, length);
    }

    @Override
    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long queueOffset) {
        return this.getConsumeQueueAsync(queueOffset, 1);
    }

    @Override
    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long queueOffset, int count) {
        return this.consumeQueue.readAsync(queueOffset * 20L, count * 20);
    }

    @Override
    public void commitCommitLog() {
        this.commitLog.commit(true);
    }

    @Override
    public void commitConsumeQueue() {
        this.consumeQueue.commit(true);
    }

    @Override
    public void cleanExpiredFile(long expireTimestamp) {
        this.commitLog.cleanExpiredFile(expireTimestamp);
        this.consumeQueue.cleanExpiredFile(expireTimestamp);
    }

    @Override
    public void destroyExpiredFile() {
        this.commitLog.destroyExpiredFile();
        this.consumeQueue.destroyExpiredFile();
    }

    @Override
    public void commit(boolean sync) {
        this.commitLog.commit(sync);
        this.consumeQueue.commit(sync);
    }

    public void increaseReadAheadFactor() {
        this.readAheadFactor = Math.min(this.readAheadFactor + 1, this.storeConfig.getReadAheadMaxFactor());
    }

    public void decreaseReadAheadFactor() {
        this.readAheadFactor = Math.max(this.readAheadFactor - 1, this.storeConfig.getReadAheadMinFactor());
    }

    public void setNotReadAhead() {
        this.readAheadFactor = 1;
    }

    public int getReadAheadFactor() {
        return this.readAheadFactor;
    }

    public void recordGroupAccess(String group, long offset) {
        this.groupOffsetCache.put((Object)group, (Object)offset);
    }

    public long getActiveGroupCount(long minOffset, long maxOffset) {
        return this.groupOffsetCache.asMap().values().stream().filter(offset -> offset >= minOffset && offset <= maxOffset).count();
    }

    public long getActiveGroupCount() {
        return this.groupOffsetCache.estimatedSize();
    }

    public InFlightRequestFuture getInflightRequest(long offset, int batchSize) {
        Optional<InFlightRequestFuture> optional = this.inFlightRequestMap.entrySet().stream().filter(entry -> {
            InFlightRequestKey key = (InFlightRequestKey)entry.getKey();
            return Math.max(key.getOffset(), offset) <= Math.min(key.getOffset() + (long)key.getBatchSize(), offset + (long)batchSize);
        }).max(Comparator.comparing(entry -> ((InFlightRequestKey)entry.getKey()).getRequestTime())).map(Map.Entry::getValue);
        return optional.orElseGet(() -> new InFlightRequestFuture(Long.MAX_VALUE, new ArrayList<Pair<Integer, CompletableFuture<Long>>>()));
    }

    public InFlightRequestFuture getInflightRequest(String group, long offset, int batchSize) {
        InFlightRequestFuture future = (InFlightRequestFuture)this.inFlightRequestMap.get(new InFlightRequestKey(group));
        if (future != null && !future.isAllDone()) {
            return future;
        }
        return this.getInflightRequest(offset, batchSize);
    }

    public void putInflightRequest(String group, long offset, int requestMsgCount, List<Pair<Integer, CompletableFuture<Long>>> futureList) {
        InFlightRequestKey key = new InFlightRequestKey(group, offset, requestMsgCount);
        this.inFlightRequestMap.remove(key);
        this.inFlightRequestMap.putIfAbsent(key, new InFlightRequestFuture(offset, futureList));
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.filePath, (CharSequence)((CompositeFlatFile)obj).filePath);
    }

    @Override
    public void shutdown() {
        this.closed = true;
        this.commitLog.commit(true);
        this.consumeQueue.commit(true);
    }

    @Override
    public void destroy() {
        this.closed = true;
        this.commitLog.destroy();
        this.consumeQueue.destroy();
        try {
            this.metadataStore.deleteFileSegment(this.filePath, FileSegmentType.COMMIT_LOG);
            this.metadataStore.deleteFileSegment(this.filePath, FileSegmentType.CONSUME_QUEUE);
        }
        catch (Exception e) {
            LOGGER.error("CompositeFlatFile#destroy: clean metadata failed: ", (Throwable)e);
        }
    }
}

