/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;

public class TieredFileSegmentInputStream
extends InputStream {
    protected final FileSegmentType fileType;
    protected final List<ByteBuffer> uploadBufferList;
    protected final int contentLength;
    protected int readPosition = 0;
    protected int curReadBufferIndex = 0;
    protected int readPosInCurBuffer = 0;
    protected ByteBuffer curBuffer;
    private int markReadPosition = -1;
    private int markCurReadBufferIndex = -1;
    private int markReadPosInCurBuffer = -1;

    public TieredFileSegmentInputStream(FileSegmentType fileType, List<ByteBuffer> uploadBufferList, int contentLength) {
        this.fileType = fileType;
        this.contentLength = contentLength;
        this.uploadBufferList = uploadBufferList;
        if (uploadBufferList != null && uploadBufferList.size() > 0) {
            this.curBuffer = uploadBufferList.get(this.curReadBufferIndex);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int ignore) {
        this.markReadPosition = this.readPosition;
        this.markCurReadBufferIndex = this.curReadBufferIndex;
        this.markReadPosInCurBuffer = this.readPosInCurBuffer;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markReadPosition == -1) {
            throw new IOException("mark not set");
        }
        this.readPosition = this.markReadPosition;
        this.curReadBufferIndex = this.markCurReadBufferIndex;
        this.readPosInCurBuffer = this.markReadPosInCurBuffer;
        if (this.curReadBufferIndex < this.uploadBufferList.size()) {
            this.curBuffer = this.uploadBufferList.get(this.curReadBufferIndex);
        }
    }

    @Override
    public int available() {
        return this.contentLength - this.readPosition;
    }

    public List<ByteBuffer> getUploadBufferList() {
        return this.uploadBufferList;
    }

    public ByteBuffer getCodaBuffer() {
        return null;
    }

    @Override
    public int read() {
        if (this.available() <= 0) {
            return -1;
        }
        ++this.readPosition;
        if (this.readPosInCurBuffer >= this.curBuffer.remaining()) {
            ++this.curReadBufferIndex;
            if (this.curReadBufferIndex >= this.uploadBufferList.size()) {
                return -1;
            }
            this.curBuffer = this.uploadBufferList.get(this.curReadBufferIndex);
            this.readPosInCurBuffer = 0;
        }
        return this.curBuffer.get(this.readPosInCurBuffer++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || len > b.length - off");
        }
        if (this.readPosition >= this.contentLength) {
            return -1;
        }
        int available = this.available();
        if (len > available) {
            len = available;
        }
        if (len <= 0) {
            return 0;
        }
        int needRead = len;
        int pos = this.readPosition;
        int bufIndex = this.curReadBufferIndex;
        int posInCurBuffer = this.readPosInCurBuffer;
        ByteBuffer curBuf = this.curBuffer;
        while (needRead > 0 && bufIndex < this.uploadBufferList.size()) {
            curBuf = this.uploadBufferList.get(bufIndex);
            int remaining = curBuf.remaining() - posInCurBuffer;
            int readLen = Math.min(remaining, needRead);
            curBuf.position(posInCurBuffer);
            curBuf.get(b, off, readLen);
            curBuf.position(0);
            off += readLen;
            needRead -= readLen;
            pos += readLen;
            if ((posInCurBuffer += readLen) != curBuf.remaining()) continue;
            ++bufIndex;
            posInCurBuffer = 0;
        }
        this.readPosition = pos;
        this.curReadBufferIndex = bufIndex;
        this.readPosInCurBuffer = posInCurBuffer;
        this.curBuffer = curBuf;
        return len;
    }
}

