/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.schedule;

import io.opentelemetry.api.common.Attributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.broker.schedule.DelayOffsetSerializeWrapper;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.running.RunningStats;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;

public class ScheduleMessageService
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long FIRST_DELAY_TIME = 1000L;
    private static final long DELAY_FOR_A_WHILE = 100L;
    private static final long DELAY_FOR_A_PERIOD = 10000L;
    private static final long WAIT_FOR_SHUTDOWN = 5000L;
    private static final long DELAY_FOR_A_SLEEP = 10L;
    private final ConcurrentSkipListMap<Integer, Long> delayLevelTable = new ConcurrentSkipListMap();
    private final ConcurrentMap<Integer, Long> offsetTable = new ConcurrentHashMap<Integer, Long>(32);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ScheduledExecutorService deliverExecutorService;
    private int maxDelayLevel;
    private DataVersion dataVersion = new DataVersion();
    private boolean enableAsyncDeliver = false;
    private ScheduledExecutorService handleExecutorService;
    private final ScheduledExecutorService scheduledPersistService;
    private final Map<Integer, LinkedBlockingQueue<PutResultProcess>> deliverPendingTable = new ConcurrentHashMap<Integer, LinkedBlockingQueue<PutResultProcess>>(32);
    private final BrokerController brokerController;
    private final transient AtomicLong versionChangeCounter = new AtomicLong(0L);

    public ScheduleMessageService(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.enableAsyncDeliver = brokerController.getMessageStoreConfig().isEnableScheduleAsyncDeliver();
        this.scheduledPersistService = ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)new ThreadFactoryImpl("ScheduleMessageServicePersistThread", true, (BrokerIdentity)brokerController.getBrokerConfig()));
    }

    public static int queueId2DelayLevel(int queueId) {
        return queueId + 1;
    }

    public static int delayLevel2QueueId(int delayLevel) {
        return delayLevel - 1;
    }

    public void buildRunningStats(HashMap<String, String> stats) {
        for (Map.Entry next : this.offsetTable.entrySet()) {
            int queueId = ScheduleMessageService.delayLevel2QueueId((Integer)next.getKey());
            long delayOffset = (Long)next.getValue();
            long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue("SCHEDULE_TOPIC_XXXX", queueId);
            String value = String.format("%d,%d", delayOffset, maxOffset);
            String key = String.format("%s_%d", RunningStats.scheduleMessageOffset.name(), next.getKey());
            stats.put(key, value);
        }
    }

    private void updateOffset(int delayLevel, long offset) {
        this.offsetTable.put(delayLevel, offset);
        if (this.versionChangeCounter.incrementAndGet() % this.brokerController.getBrokerConfig().getDelayOffsetUpdateVersionStep() == 0L) {
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            this.dataVersion.nextVersion(stateMachineVersion);
        }
    }

    public long computeDeliverTimestamp(int delayLevel, long storeTimestamp) {
        Long time = this.delayLevelTable.get(delayLevel);
        if (time != null) {
            return time + storeTimestamp;
        }
        return storeTimestamp + 1000L;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.load();
            this.deliverExecutorService = ThreadUtils.newScheduledThreadPool((int)this.maxDelayLevel, (ThreadFactory)new ThreadFactoryImpl("ScheduleMessageTimerThread_"));
            if (this.enableAsyncDeliver) {
                this.handleExecutorService = ThreadUtils.newScheduledThreadPool((int)this.maxDelayLevel, (ThreadFactory)new ThreadFactoryImpl("ScheduleMessageExecutorHandleThread_"));
            }
            for (Map.Entry<Integer, Long> entry : this.delayLevelTable.entrySet()) {
                Integer level = entry.getKey();
                Long timeDelay = entry.getValue();
                Long offset = (Long)this.offsetTable.get(level);
                if (null == offset) {
                    offset = 0L;
                }
                if (timeDelay == null) continue;
                if (this.enableAsyncDeliver) {
                    this.handleExecutorService.schedule(new HandlePutResultTask(level), 1000L, TimeUnit.MILLISECONDS);
                }
                this.deliverExecutorService.schedule(new DeliverDelayedMessageTimerTask(level, offset), 1000L, TimeUnit.MILLISECONDS);
            }
            this.scheduledPersistService.scheduleAtFixedRate(() -> {
                try {
                    this.persist();
                }
                catch (Throwable e) {
                    log.error("scheduleAtFixedRate flush exception", e);
                }
            }, 10000L, this.brokerController.getMessageStoreConfig().getFlushDelayOffsetInterval(), TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        this.stop();
        ThreadUtils.shutdown((ExecutorService)this.scheduledPersistService);
    }

    public boolean stop() {
        if (this.started.compareAndSet(true, false) && null != this.deliverExecutorService) {
            this.deliverExecutorService.shutdown();
            try {
                this.deliverExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("deliverExecutorService awaitTermination error", (Throwable)e);
            }
            if (this.handleExecutorService != null) {
                this.handleExecutorService.shutdown();
                try {
                    this.handleExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.error("handleExecutorService awaitTermination error", (Throwable)e);
                }
            }
            for (int i = 1; i <= this.deliverPendingTable.size(); ++i) {
                log.warn("deliverPendingTable level: {}, size: {}", (Object)i, (Object)this.deliverPendingTable.get(i).size());
            }
            this.persist();
        }
        return true;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public int getMaxDelayLevel() {
        return this.maxDelayLevel;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String encode() {
        return this.encode(false);
    }

    public boolean load() {
        boolean result = super.load();
        result = result && this.parseDelayLevel();
        result = result && this.correctDelayOffset();
        return result;
    }

    public boolean loadWhenSyncDelayOffset() {
        boolean result = super.load();
        result = result && this.parseDelayLevel();
        return result;
    }

    public boolean correctDelayOffset() {
        try {
            Iterator iterator = this.delayLevelTable.keySet().iterator();
            while (iterator.hasNext()) {
                int delayLevel = (Integer)iterator.next();
                ConsumeQueueInterface cq = this.brokerController.getMessageStore().getQueueStore().findOrCreateConsumeQueue("SCHEDULE_TOPIC_XXXX", ScheduleMessageService.delayLevel2QueueId(delayLevel));
                Long currentDelayOffset = (Long)this.offsetTable.get(delayLevel);
                if (currentDelayOffset == null || cq == null) continue;
                long correctDelayOffset = currentDelayOffset;
                long cqMinOffset = cq.getMinOffsetInQueue();
                long cqMaxOffset = cq.getMaxOffsetInQueue();
                if (currentDelayOffset < cqMinOffset) {
                    correctDelayOffset = cqMinOffset;
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, cqMaxOffset={}, queueId={}", new Object[]{currentDelayOffset, cqMinOffset, cqMaxOffset, cq.getQueueId()});
                }
                if (currentDelayOffset > cqMaxOffset) {
                    correctDelayOffset = cqMaxOffset;
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, cqMaxOffset={}, queueId={}", new Object[]{currentDelayOffset, cqMinOffset, cqMaxOffset, cq.getQueueId()});
                }
                if (correctDelayOffset == currentDelayOffset) continue;
                log.error("correct delay offset [ delayLevel {} ] from {} to {}", new Object[]{delayLevel, currentDelayOffset, correctDelayOffset});
                this.offsetTable.put(delayLevel, correctDelayOffset);
            }
        }
        catch (Exception e) {
            log.error("correctDelayOffset exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public String configFilePath() {
        return StorePathConfigHelper.getDelayOffsetStorePath((String)this.brokerController.getMessageStore().getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper;
        if (jsonString != null && (delayOffsetSerializeWrapper = (DelayOffsetSerializeWrapper)((Object)DelayOffsetSerializeWrapper.fromJson((String)jsonString, DelayOffsetSerializeWrapper.class))) != null) {
            this.offsetTable.putAll(delayOffsetSerializeWrapper.getOffsetTable());
            if (delayOffsetSerializeWrapper.getDataVersion() != null) {
                this.dataVersion.assignNewOne(delayOffsetSerializeWrapper.getDataVersion());
            }
        }
    }

    public String encode(boolean prettyFormat) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper = new DelayOffsetSerializeWrapper();
        delayOffsetSerializeWrapper.setOffsetTable(this.offsetTable);
        delayOffsetSerializeWrapper.setDataVersion(this.dataVersion);
        return delayOffsetSerializeWrapper.toJson(prettyFormat);
    }

    public boolean parseDelayLevel() {
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.brokerController.getMessageStoreConfig().getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                if (level > this.maxDelayLevel) {
                    this.maxDelayLevel = level;
                }
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
                if (!this.enableAsyncDeliver) continue;
                this.deliverPendingTable.put(level, new LinkedBlockingQueue());
            }
        }
        catch (Exception e) {
            log.error("parse message delay level failed. messageDelayLevel = {}", (Object)levelString, (Object)e);
            return false;
        }
        return true;
    }

    private MessageExtBrokerInner messageTimeUp(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        TopicFilterType topicFilterType = MessageExt.parseTopicFilterType((int)msgInner.getSysFlag());
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        MessageAccessor.clearProperty((Message)msgInner, (String)"DELAY");
        MessageAccessor.clearProperty((Message)msgInner, (String)"TIMER_DELIVER_MS");
        MessageAccessor.clearProperty((Message)msgInner, (String)"TIMER_DELAY_SEC");
        msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
        String queueIdStr = msgInner.getProperty("REAL_QID");
        int queueId = Integer.parseInt(queueIdStr);
        msgInner.setQueueId(queueId);
        return msgInner;
    }

    public ConcurrentMap<Integer, Long> getOffsetTable() {
        return this.offsetTable;
    }

    public static enum ProcessStatus {
        RUNNING,
        SUCCESS,
        EXCEPTION,
        SKIP;

    }

    public class PutResultProcess {
        private String topic;
        private long offset;
        private long physicOffset;
        private int physicSize;
        private int delayLevel;
        private String msgId;
        private boolean autoResend = false;
        private CompletableFuture<PutMessageResult> future;
        private volatile AtomicInteger resendCount = new AtomicInteger(0);
        private volatile ProcessStatus status = ProcessStatus.RUNNING;

        public PutResultProcess setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public PutResultProcess setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public PutResultProcess setPhysicOffset(long physicOffset) {
            this.physicOffset = physicOffset;
            return this;
        }

        public PutResultProcess setPhysicSize(int physicSize) {
            this.physicSize = physicSize;
            return this;
        }

        public PutResultProcess setDelayLevel(int delayLevel) {
            this.delayLevel = delayLevel;
            return this;
        }

        public PutResultProcess setMsgId(String msgId) {
            this.msgId = msgId;
            return this;
        }

        public PutResultProcess setAutoResend(boolean autoResend) {
            this.autoResend = autoResend;
            return this;
        }

        public PutResultProcess setFuture(CompletableFuture<PutMessageResult> future) {
            this.future = future;
            return this;
        }

        public String getTopic() {
            return this.topic;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getNextOffset() {
            return this.offset + 1L;
        }

        public long getPhysicOffset() {
            return this.physicOffset;
        }

        public int getPhysicSize() {
            return this.physicSize;
        }

        public Integer getDelayLevel() {
            return this.delayLevel;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public boolean isAutoResend() {
            return this.autoResend;
        }

        public CompletableFuture<PutMessageResult> getFuture() {
            return this.future;
        }

        public AtomicInteger getResendCount() {
            return this.resendCount;
        }

        public PutResultProcess thenProcess() {
            this.future.thenAccept(this::handleResult);
            this.future.exceptionally(e -> {
                log.error("ScheduleMessageService put message exceptionally, info: {}", (Object)this.toString(), e);
                this.onException();
                return null;
            });
            return this;
        }

        private void handleResult(PutMessageResult result) {
            if (result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                this.onSuccess(result);
            } else {
                log.warn("ScheduleMessageService put message failed. info: {}.", (Object)result);
                this.onException();
            }
        }

        public void onSuccess(PutMessageResult result) {
            this.status = ProcessStatus.SUCCESS;
            if (ScheduleMessageService.this.brokerController.getMessageStore().getMessageStoreConfig().isEnableScheduleMessageStats() && !result.isRemotePut()) {
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incQueueGetNums("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", Integer.valueOf(this.delayLevel - 1), result.getAppendMessageResult().getMsgNum());
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incQueueGetSize("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", Integer.valueOf(this.delayLevel - 1), result.getAppendMessageResult().getWroteBytes());
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incGroupGetNums("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", result.getAppendMessageResult().getMsgNum());
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incGroupGetSize("SCHEDULE_CONSUMER", "SCHEDULE_TOPIC_XXXX", result.getAppendMessageResult().getWroteBytes());
                Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("topic", "SCHEDULE_TOPIC_XXXX").put("consumer_group", "SCHEDULE_CONSUMER").put("is_system", true).build();
                BrokerMetricsManager.messagesOutTotal.add((long)result.getAppendMessageResult().getMsgNum(), attributes);
                BrokerMetricsManager.throughputOutTotal.add((long)result.getAppendMessageResult().getWroteBytes(), attributes);
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incTopicPutNums(this.topic, result.getAppendMessageResult().getMsgNum(), 1);
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incTopicPutSize(this.topic, result.getAppendMessageResult().getWroteBytes());
                ScheduleMessageService.this.brokerController.getBrokerStatsManager().incBrokerPutNums(this.topic, result.getAppendMessageResult().getMsgNum());
                attributes = BrokerMetricsManager.newAttributesBuilder().put("topic", this.topic).put("message_type", TopicMessageType.DELAY.getMetricsValue()).put("is_system", TopicValidator.isSystemTopic((String)this.topic)).build();
                BrokerMetricsManager.messagesInTotal.add((long)result.getAppendMessageResult().getMsgNum(), attributes);
                BrokerMetricsManager.throughputInTotal.add((long)result.getAppendMessageResult().getWroteBytes(), attributes);
                BrokerMetricsManager.messageSize.record((long)(result.getAppendMessageResult().getWroteBytes() / result.getAppendMessageResult().getMsgNum()), attributes);
            }
        }

        public void onException() {
            log.warn("ScheduleMessageService onException, info: {}", (Object)this.toString());
            this.status = this.autoResend ? ProcessStatus.EXCEPTION : ProcessStatus.SKIP;
        }

        public ProcessStatus getStatus() {
            return this.status;
        }

        public PutMessageResult get() {
            try {
                return this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null);
            }
        }

        public void doResend() {
            log.info("Resend message, info: {}", (Object)this.toString());
            try {
                Thread.sleep(Math.min(this.resendCount.incrementAndGet() * 100, 60000));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                MessageExt msgExt = ScheduleMessageService.this.brokerController.getMessageStore().lookMessageByOffset(this.physicOffset, this.physicSize);
                if (msgExt == null) {
                    log.warn("ScheduleMessageService resend not found message. info: {}", (Object)this.toString());
                    this.status = this.need2Skip() ? ProcessStatus.SKIP : ProcessStatus.EXCEPTION;
                    return;
                }
                MessageExtBrokerInner msgInner = ScheduleMessageService.this.messageTimeUp(msgExt);
                PutMessageResult result = ScheduleMessageService.this.brokerController.getEscapeBridge().putMessage(msgInner);
                this.handleResult(result);
                if (result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                    log.info("Resend message success, info: {}", (Object)this.toString());
                }
            }
            catch (Exception e) {
                this.status = ProcessStatus.EXCEPTION;
                log.error("Resend message error, info: {}", (Object)this.toString(), (Object)e);
            }
        }

        public boolean need2Blocked() {
            int maxResendNum2Blocked = ScheduleMessageService.this.brokerController.getMessageStore().getMessageStoreConfig().getScheduleAsyncDeliverMaxResendNum2Blocked();
            return this.resendCount.get() > maxResendNum2Blocked;
        }

        public boolean need2Skip() {
            int maxResendNum2Blocked = ScheduleMessageService.this.brokerController.getMessageStore().getMessageStoreConfig().getScheduleAsyncDeliverMaxResendNum2Blocked();
            return this.resendCount.get() > maxResendNum2Blocked * 2;
        }

        public String toString() {
            return "PutResultProcess{topic='" + this.topic + '\'' + ", offset=" + this.offset + ", physicOffset=" + this.physicOffset + ", physicSize=" + this.physicSize + ", delayLevel=" + this.delayLevel + ", msgId='" + this.msgId + '\'' + ", autoResend=" + this.autoResend + ", resendCount=" + this.resendCount + ", status=" + (Object)((Object)this.status) + '}';
        }
    }

    public class HandlePutResultTask
    implements Runnable {
        private final int delayLevel;

        public HandlePutResultTask(int delayLevel) {
            this.delayLevel = delayLevel;
        }

        @Override
        public void run() {
            PutResultProcess putResultProcess;
            LinkedBlockingQueue pendingQueue = (LinkedBlockingQueue)ScheduleMessageService.this.deliverPendingTable.get(this.delayLevel);
            while ((putResultProcess = (PutResultProcess)pendingQueue.peek()) != null) {
                try {
                    switch (putResultProcess.getStatus()) {
                        case SUCCESS: {
                            ScheduleMessageService.this.updateOffset(this.delayLevel, putResultProcess.getNextOffset());
                            pendingQueue.remove();
                            break;
                        }
                        case RUNNING: {
                            this.scheduleNextTask();
                            return;
                        }
                        case EXCEPTION: {
                            if (!ScheduleMessageService.this.isStarted()) {
                                log.warn("HandlePutResultTask shutdown, info={}", (Object)putResultProcess.toString());
                                return;
                            }
                            log.warn("putResultProcess error, info={}", (Object)putResultProcess.toString());
                            putResultProcess.doResend();
                            break;
                        }
                        case SKIP: {
                            log.warn("putResultProcess skip, info={}", (Object)putResultProcess.toString());
                            pendingQueue.remove();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("HandlePutResultTask exception. info={}", (Object)putResultProcess.toString(), (Object)e);
                    putResultProcess.doResend();
                }
            }
            this.scheduleNextTask();
        }

        private void scheduleNextTask() {
            if (ScheduleMessageService.this.isStarted()) {
                ScheduleMessageService.this.handleExecutorService.schedule(new HandlePutResultTask(this.delayLevel), 10L, TimeUnit.MILLISECONDS);
            }
        }
    }

    class DeliverDelayedMessageTimerTask
    implements Runnable {
        private final int delayLevel;
        private final long offset;

        public DeliverDelayedMessageTimerTask(int delayLevel, long offset) {
            this.delayLevel = delayLevel;
            this.offset = offset;
        }

        @Override
        public void run() {
            try {
                if (ScheduleMessageService.this.isStarted()) {
                    this.executeOnTimeUp();
                }
            }
            catch (Throwable e) {
                log.error("ScheduleMessageService, executeOnTimeUp exception", e);
                this.scheduleNextTimerTask(this.offset, 10000L);
            }
        }

        private long correctDeliverTimestamp(long now, long deliverTimestamp) {
            long result = deliverTimestamp;
            long maxTimestamp = now + (Long)ScheduleMessageService.this.delayLevelTable.get(this.delayLevel);
            if (deliverTimestamp > maxTimestamp) {
                result = now;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOnTimeUp() {
            ConsumeQueueInterface cq = ScheduleMessageService.this.brokerController.getMessageStore().getConsumeQueue("SCHEDULE_TOPIC_XXXX", ScheduleMessageService.delayLevel2QueueId(this.delayLevel));
            if (cq == null) {
                this.scheduleNextTimerTask(this.offset, 100L);
                return;
            }
            ReferredIterator bufferCQ = cq.iterateFrom(this.offset);
            if (bufferCQ == null) {
                long resetOffset = cq.getMinOffsetInQueue();
                if (resetOffset > this.offset) {
                    log.error("schedule CQ offset invalid. offset={}, cqMinOffset={}, queueId={}", new Object[]{this.offset, resetOffset, cq.getQueueId()});
                } else {
                    resetOffset = cq.getMaxOffsetInQueue();
                    if (resetOffset < this.offset) {
                        log.error("schedule CQ offset invalid. offset={}, cqMaxOffset={}, queueId={}", new Object[]{this.offset, resetOffset, cq.getQueueId()});
                    } else {
                        resetOffset = this.offset;
                    }
                }
                this.scheduleNextTimerTask(resetOffset, 100L);
                return;
            }
            long nextOffset = this.offset;
            try {
                while (bufferCQ.hasNext() && ScheduleMessageService.this.isStarted()) {
                    CqUnit cqUnit = (CqUnit)bufferCQ.next();
                    long offsetPy = cqUnit.getPos();
                    int sizePy = cqUnit.getSize();
                    long tagsCode = cqUnit.getTagsCode();
                    if (!cqUnit.isTagsCodeValid()) {
                        log.error("[BUG] can't find consume queue extend file content!addr={}, offsetPy={}, sizePy={}", new Object[]{tagsCode, offsetPy, sizePy});
                        long msgStoreTime = ScheduleMessageService.this.brokerController.getMessageStore().getCommitLog().pickupStoreTimestamp(offsetPy, sizePy);
                        tagsCode = ScheduleMessageService.this.computeDeliverTimestamp(this.delayLevel, msgStoreTime);
                    }
                    long now = System.currentTimeMillis();
                    long deliverTimestamp = this.correctDeliverTimestamp(now, tagsCode);
                    long currOffset = cqUnit.getQueueOffset();
                    assert (cqUnit.getBatchNum() == 1);
                    nextOffset = currOffset + (long)cqUnit.getBatchNum();
                    long countdown = deliverTimestamp - now;
                    if (countdown > 0L) {
                        this.scheduleNextTimerTask(currOffset, 100L);
                        ScheduleMessageService.this.updateOffset(this.delayLevel, currOffset);
                        return;
                    }
                    MessageExt msgExt = ScheduleMessageService.this.brokerController.getMessageStore().lookMessageByOffset(offsetPy, sizePy);
                    if (msgExt == null) continue;
                    MessageExtBrokerInner msgInner = ScheduleMessageService.this.messageTimeUp(msgExt);
                    if ("RMQ_SYS_TRANS_HALF_TOPIC".equals(msgInner.getTopic())) {
                        log.error("[BUG] the real topic of schedule msg is {}, discard the msg. msg={}", (Object)msgInner.getTopic(), (Object)msgInner);
                        continue;
                    }
                    boolean deliverSuc = ScheduleMessageService.this.enableAsyncDeliver ? this.asyncDeliver(msgInner, msgExt.getMsgId(), currOffset, offsetPy, sizePy) : this.syncDeliver(msgInner, msgExt.getMsgId(), currOffset, offsetPy, sizePy);
                    if (deliverSuc) continue;
                    this.scheduleNextTimerTask(nextOffset, 100L);
                    return;
                }
            }
            catch (Exception e) {
                log.error("ScheduleMessageService, messageTimeUp execute error, offset = {}", (Object)nextOffset, (Object)e);
            }
            finally {
                bufferCQ.release();
            }
            this.scheduleNextTimerTask(nextOffset, 100L);
        }

        public void scheduleNextTimerTask(long offset, long delay) {
            ScheduleMessageService.this.deliverExecutorService.schedule(new DeliverDelayedMessageTimerTask(this.delayLevel, offset), delay, TimeUnit.MILLISECONDS);
        }

        private boolean syncDeliver(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy) {
            boolean sendStatus;
            PutResultProcess resultProcess = this.deliverMessage(msgInner, msgId, offset, offsetPy, sizePy, false);
            PutMessageResult result = resultProcess.get();
            boolean bl = sendStatus = result != null && result.getPutMessageStatus() == PutMessageStatus.PUT_OK;
            if (sendStatus) {
                ScheduleMessageService.this.updateOffset(this.delayLevel, resultProcess.getNextOffset());
            }
            return sendStatus;
        }

        private boolean asyncDeliver(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy) {
            int maxPendingLimit;
            Queue processesQueue = (Queue)ScheduleMessageService.this.deliverPendingTable.get(this.delayLevel);
            int currentPendingNum = processesQueue.size();
            if (currentPendingNum > (maxPendingLimit = ScheduleMessageService.this.brokerController.getMessageStoreConfig().getScheduleAsyncDeliverMaxPendingLimit())) {
                log.warn("Asynchronous deliver triggers flow control, currentPendingNum={}, maxPendingLimit={}", (Object)currentPendingNum, (Object)maxPendingLimit);
                return false;
            }
            PutResultProcess firstProcess = (PutResultProcess)processesQueue.peek();
            if (firstProcess != null && firstProcess.need2Blocked()) {
                log.warn("Asynchronous deliver block. info={}", (Object)firstProcess.toString());
                return false;
            }
            PutResultProcess resultProcess = this.deliverMessage(msgInner, msgId, offset, offsetPy, sizePy, true);
            processesQueue.add(resultProcess);
            return true;
        }

        private PutResultProcess deliverMessage(MessageExtBrokerInner msgInner, String msgId, long offset, long offsetPy, int sizePy, boolean autoResend) {
            CompletableFuture<PutMessageResult> future = ScheduleMessageService.this.brokerController.getEscapeBridge().asyncPutMessage(msgInner);
            return new PutResultProcess().setTopic(msgInner.getTopic()).setDelayLevel(this.delayLevel).setOffset(offset).setPhysicOffset(offsetPy).setPhysicSize(sizePy).setMsgId(msgId).setAutoResend(autoResend).setFuture(future).thenProcess();
        }
    }
}

