/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ThreadUtils;

public class MessageStoreExecutor {
    public final BlockingQueue<Runnable> bufferCommitThreadPoolQueue;
    public final BlockingQueue<Runnable> bufferFetchThreadPoolQueue;
    public final BlockingQueue<Runnable> fileRecyclingThreadPoolQueue;
    public final ScheduledExecutorService commonExecutor = ThreadUtils.newScheduledThreadPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCommonExecutor_"));
    public final ExecutorService bufferCommitExecutor;
    public final ExecutorService bufferFetchExecutor;
    public final ExecutorService fileRecyclingExecutor;

    public static MessageStoreExecutor getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public MessageStoreExecutor() {
        this(10000);
    }

    public MessageStoreExecutor(int maxQueueCapacity) {
        this.bufferCommitThreadPoolQueue = new LinkedBlockingQueue<Runnable>(maxQueueCapacity);
        this.bufferCommitExecutor = ThreadUtils.newThreadPoolExecutor((int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (long)TimeUnit.MINUTES.toMillis(1L), (TimeUnit)TimeUnit.MILLISECONDS, this.bufferCommitThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("BufferCommitExecutor_"));
        this.bufferFetchThreadPoolQueue = new LinkedBlockingQueue<Runnable>(maxQueueCapacity);
        this.bufferFetchExecutor = ThreadUtils.newThreadPoolExecutor((int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (long)TimeUnit.MINUTES.toMillis(1L), (TimeUnit)TimeUnit.MILLISECONDS, this.bufferFetchThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("BufferFetchExecutor_"));
        this.fileRecyclingThreadPoolQueue = new LinkedBlockingQueue<Runnable>(maxQueueCapacity);
        this.fileRecyclingExecutor = ThreadUtils.newThreadPoolExecutor((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (int)Math.max(4, Runtime.getRuntime().availableProcessors()), (long)TimeUnit.MINUTES.toMillis(1L), (TimeUnit)TimeUnit.MILLISECONDS, this.fileRecyclingThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("BufferFetchExecutor_"));
    }

    private void shutdownExecutor(ExecutorService executor) {
        if (executor != null) {
            executor.shutdown();
        }
    }

    public void shutdown() {
        this.shutdownExecutor(this.commonExecutor);
        this.shutdownExecutor(this.bufferCommitExecutor);
        this.shutdownExecutor(this.bufferFetchExecutor);
        this.shutdownExecutor(this.fileRecyclingExecutor);
    }

    private static class SingletonHolder {
        private static final MessageStoreExecutor INSTANCE = new MessageStoreExecutor();

        private SingletonHolder() {
        }
    }
}

