/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigurationManager;

public class ReceiptHandleGroup {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final Map<String, Map<HandleKey, HandleData>> receiptHandleMap = new ConcurrentHashMap<String, Map<HandleKey, HandleData>>();

    public void put(String msgID, MessageReceiptHandle value) {
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        Map handleMap = (Map)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)((ConcurrentHashMap)this.receiptHandleMap), (Object)msgID, msgIDKey -> new ConcurrentHashMap());
        handleMap.compute(new HandleKey(value.getOriginalReceiptHandle()), (handleKey, handleData) -> {
            if (handleData == null || ((HandleData)handleData).needRemove) {
                return new HandleData(value);
            }
            Long lockTimeMs = handleData.lock(timeout);
            if (lockTimeMs == null) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to put handle failed");
            }
            try {
                if (((HandleData)handleData).needRemove) {
                    HandleData handleData2 = new HandleData(value);
                    return handleData2;
                }
                ((HandleData)handleData).messageReceiptHandle = value;
            }
            finally {
                handleData.unlock(lockTimeMs);
            }
            return handleData;
        });
    }

    public boolean isEmpty() {
        return this.receiptHandleMap.isEmpty();
    }

    public MessageReceiptHandle get(String msgID, String handle) {
        Map<HandleKey, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return null;
        }
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        AtomicReference res = new AtomicReference();
        handleMap.computeIfPresent(new HandleKey(handle), (handleKey, handleData) -> {
            Long lockTimeMs = handleData.lock(timeout);
            if (lockTimeMs == null) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to get handle failed");
            }
            try {
                if (((HandleData)handleData).needRemove) {
                    HandleData handleData2 = null;
                    return handleData2;
                }
                res.set(((HandleData)handleData).messageReceiptHandle);
            }
            finally {
                handleData.unlock(lockTimeMs);
            }
            return handleData;
        });
        return (MessageReceiptHandle)res.get();
    }

    public MessageReceiptHandle remove(String msgID, String handle) {
        Map<HandleKey, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return null;
        }
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        AtomicReference res = new AtomicReference();
        handleMap.computeIfPresent(new HandleKey(handle), (handleKey, handleData) -> {
            Long lockTimeMs = handleData.lock(timeout);
            if (lockTimeMs == null) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to remove and get handle failed");
            }
            try {
                if (!((HandleData)handleData).needRemove) {
                    ((HandleData)handleData).needRemove = true;
                    res.set(((HandleData)handleData).messageReceiptHandle);
                }
                HandleData handleData2 = null;
                return handleData2;
            }
            finally {
                handleData.unlock(lockTimeMs);
            }
        });
        this.removeHandleMapKeyIfNeed(msgID);
        return (MessageReceiptHandle)res.get();
    }

    public MessageReceiptHandle removeOne(String msgID) {
        Map<HandleKey, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return null;
        }
        Set<HandleKey> keys = handleMap.keySet();
        for (HandleKey key : keys) {
            MessageReceiptHandle res = this.remove(msgID, key.originalHandle);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void computeIfPresent(String msgID, String handle, Function<MessageReceiptHandle, CompletableFuture<MessageReceiptHandle>> function) {
        Map<HandleKey, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return;
        }
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        handleMap.computeIfPresent(new HandleKey(handle), (handleKey, handleData) -> {
            Long lockTimeMs = handleData.lock(timeout);
            if (lockTimeMs == null) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to compute failed");
            }
            CompletableFuture future = (CompletableFuture)function.apply(((HandleData)handleData).messageReceiptHandle);
            future.whenComplete((messageReceiptHandle, throwable) -> {
                try {
                    if (throwable != null) {
                        return;
                    }
                    if (messageReceiptHandle == null) {
                        ((HandleData)handleData).needRemove = true;
                    } else {
                        ((HandleData)handleData).messageReceiptHandle = messageReceiptHandle;
                    }
                }
                finally {
                    handleData.unlock(lockTimeMs);
                }
                if (((HandleData)handleData).needRemove) {
                    handleMap.remove(handleKey, handleData);
                }
                this.removeHandleMapKeyIfNeed(msgID);
            });
            return handleData;
        });
    }

    protected void removeHandleMapKeyIfNeed(String msgID) {
        this.receiptHandleMap.computeIfPresent(msgID, (msgIDKey, handleMap) -> {
            if (handleMap.isEmpty()) {
                return null;
            }
            return handleMap;
        });
    }

    public void scan(DataScanner scanner) {
        this.receiptHandleMap.forEach((msgID, handleMap) -> handleMap.forEach((handleKey, v) -> scanner.onData((String)msgID, ((HandleKey)handleKey).originalHandle, ((HandleData)v).messageReceiptHandle)));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("receiptHandleMap", this.receiptHandleMap).toString();
    }

    public static interface DataScanner {
        public void onData(String var1, String var2, MessageReceiptHandle var3);
    }

    public static class HandleData {
        private final Semaphore semaphore = new Semaphore(1);
        private final AtomicLong lastLockTimeMs = new AtomicLong(-1L);
        private volatile boolean needRemove = false;
        private volatile MessageReceiptHandle messageReceiptHandle;

        public HandleData(MessageReceiptHandle messageReceiptHandle) {
            this.messageReceiptHandle = messageReceiptHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long lock(long timeoutMs) {
            try {
                boolean result = this.semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS);
                long currentTimeMs = System.currentTimeMillis();
                if (result) {
                    this.lastLockTimeMs.set(currentTimeMs);
                    return currentTimeMs;
                }
                long expiredTimeMs = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup() * 3L;
                if (currentTimeMs - this.lastLockTimeMs.get() > expiredTimeMs) {
                    HandleData handleData = this;
                    synchronized (handleData) {
                        if (currentTimeMs - this.lastLockTimeMs.get() > expiredTimeMs) {
                            log.warn("HandleData lock expired, acquire lock success and reset lock time. MessageReceiptHandle={}, lockTime={}", (Object)this.messageReceiptHandle, (Object)currentTimeMs);
                            this.lastLockTimeMs.set(currentTimeMs);
                            return currentTimeMs;
                        }
                    }
                }
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        public void unlock(long lockTimeMs) {
            if (System.currentTimeMillis() - lockTimeMs > ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup() * 2L) {
                log.warn("HandleData lock expired, unlock fail. MessageReceiptHandle={}, lockTime={}, now={}", new Object[]{this.messageReceiptHandle, lockTimeMs, System.currentTimeMillis()});
                return;
            }
            this.semaphore.release();
        }

        public MessageReceiptHandle getMessageReceiptHandle() {
            return this.messageReceiptHandle;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.semaphore, this.needRemove, this.messageReceiptHandle});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("semaphore", (Object)this.semaphore).add("needRemove", this.needRemove).add("messageReceiptHandle", (Object)this.messageReceiptHandle).toString();
        }
    }

    public static class HandleKey {
        private final String originalHandle;
        private final String broker;
        private final int queueId;
        private final long offset;

        public HandleKey(String handle) {
            this(ReceiptHandle.decode((String)handle));
        }

        public HandleKey(ReceiptHandle receiptHandle) {
            this.originalHandle = receiptHandle.getReceiptHandle();
            this.broker = receiptHandle.getBrokerName();
            this.queueId = receiptHandle.getQueueId();
            this.offset = receiptHandle.getOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandleKey key = (HandleKey)o;
            return this.queueId == key.queueId && this.offset == key.offset && Objects.equal((Object)this.broker, (Object)key.broker);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.broker, this.queueId, this.offset});
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("originalHandle", (Object)this.originalHandle).append("broker", (Object)this.broker).append("queueId", this.queueId).append("offset", this.offset).toString();
        }

        public String getOriginalHandle() {
            return this.originalHandle;
        }

        public String getBroker() {
            return this.broker;
        }

        public int getQueueId() {
            return this.queueId;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

