/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

final class ConstructorFunction<T>
implements Function<Map<Long, Object>, T> {
    final Constructor constructor;
    final Function function;
    final BiFunction biFunction;
    final Parameter[] parameters;
    final String[] paramNames;
    final boolean marker;
    final long[] hashCodes;
    final List<Constructor> alternateConstructors;
    Map<Set<Long>, Constructor> alternateConstructorMap;
    Map<Set<Long>, String[]> alternateConstructorNames;
    Map<Set<Long>, long[]> alternateConstructorNameHashCodes;
    Map<Set<Long>, Type[]> alternateConstructorArgTypes;

    ConstructorFunction(List<Constructor> alternateConstructors, Constructor constructor, Function function, BiFunction biFunction, Constructor markerConstructor, String ... paramNames) {
        this.function = function;
        this.biFunction = biFunction;
        this.marker = markerConstructor != null;
        this.constructor = this.marker ? markerConstructor : constructor;
        this.parameters = constructor.getParameters();
        this.paramNames = paramNames;
        this.hashCodes = new long[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            String name = i < paramNames.length ? paramNames[i] : this.parameters[i].getName();
            if (name == null) {
                name = "arg" + i;
            }
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
        this.alternateConstructors = alternateConstructors;
        if (alternateConstructors != null) {
            int size = alternateConstructors.size();
            this.alternateConstructorMap = new HashMap<Set<Long>, Constructor>(size, 1.0f);
            this.alternateConstructorNames = new HashMap<Set<Long>, String[]>(size, 1.0f);
            this.alternateConstructorArgTypes = new HashMap<Set<Long>, Type[]>(size, 1.0f);
            this.alternateConstructorNameHashCodes = new HashMap<Set<Long>, long[]>(size, 1.0f);
            for (int i = 0; i < size; ++i) {
                Constructor alternateConstructor = alternateConstructors.get(i);
                alternateConstructor.setAccessible(true);
                String[] parameterNames = ASMUtils.lookupParameterNames(alternateConstructor);
                Parameter[] parameters = alternateConstructor.getParameters();
                FieldInfo fieldInfo = new FieldInfo();
                ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
                for (int j = 0; j < parameters.length && j < parameterNames.length; ++j) {
                    fieldInfo.init();
                    Parameter parameter = parameters[j];
                    provider.getFieldInfo(fieldInfo, alternateConstructor.getDeclaringClass(), alternateConstructor, j, parameter);
                    if (fieldInfo.fieldName == null) continue;
                    parameterNames[j] = fieldInfo.fieldName;
                }
                long[] parameterNameHashCodes = new long[parameterNames.length];
                Type[] parameterTypes = alternateConstructor.getGenericParameterTypes();
                HashSet<Long> paramHashCodes = new HashSet<Long>(parameterNames.length);
                for (int j = 0; j < parameterNames.length; ++j) {
                    long hashCode64;
                    parameterNameHashCodes[j] = hashCode64 = Fnv.hashCode64(parameterNames[j]);
                    paramHashCodes.add(hashCode64);
                }
                this.alternateConstructorMap.put(paramHashCodes, alternateConstructor);
                this.alternateConstructorNames.put(paramHashCodes, parameterNames);
                this.alternateConstructorNameHashCodes.put(paramHashCodes, parameterNameHashCodes);
                this.alternateConstructorArgTypes.put(paramHashCodes, parameterTypes);
            }
        }
    }

    @Override
    public T apply(Map<Long, Object> values) {
        int i;
        Set<Long> key;
        Constructor constructor;
        boolean containsAll = true;
        for (long hashCode : this.hashCodes) {
            if (values.containsKey(hashCode)) continue;
            containsAll = false;
            break;
        }
        if (!containsAll && this.alternateConstructorMap != null && (constructor = this.alternateConstructorMap.get(key = values.keySet())) != null) {
            long[] hashCodes = this.alternateConstructorNameHashCodes.get(key);
            Type[] paramTypes = this.alternateConstructorArgTypes.get(key);
            Object[] args = new Object[hashCodes.length];
            for (int i2 = 0; i2 < hashCodes.length; ++i2) {
                Object arg = values.get(hashCodes[i2]);
                Type paramType = paramTypes[i2];
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramType);
                }
                args[i2] = arg;
            }
            try {
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke constructor error, " + constructor, e);
            }
        }
        if (this.function != null && this.parameters.length == 1) {
            Parameter param = this.parameters[0];
            Object arg = values.get(this.hashCodes[0]);
            Class<?> paramType = param.getType();
            if (arg == null) {
                arg = TypeUtils.getDefaultValue(paramType);
            } else if (!paramType.isInstance(arg)) {
                arg = TypeUtils.cast(arg, paramType);
            }
            return (T)this.function.apply(arg);
        }
        if (this.biFunction != null && this.parameters.length == 2) {
            Object arg0 = values.get(this.hashCodes[0]);
            Parameter param0 = this.parameters[0];
            Class<?> param0Type = param0.getType();
            if (arg0 == null) {
                arg0 = TypeUtils.getDefaultValue(param0Type);
            } else if (!param0Type.isInstance(arg0)) {
                arg0 = TypeUtils.cast(arg0, param0Type);
            }
            Object arg1 = values.get(this.hashCodes[1]);
            Parameter param1 = this.parameters[1];
            Class<?> param1Type = param1.getType();
            if (arg1 == null) {
                arg1 = TypeUtils.getDefaultValue(param1Type);
            } else if (!param1Type.isInstance(arg1)) {
                arg1 = TypeUtils.cast(arg1, param1Type);
            }
            return (T)this.biFunction.apply(arg0, arg1);
        }
        int size = this.parameters.length;
        Object[] args = new Object[this.constructor.getParameterCount()];
        if (this.marker) {
            i = 0;
            int flag = 0;
            while (i < size) {
                Object arg = values.get(this.hashCodes[i]);
                if (arg != null) {
                    args[i] = arg;
                } else {
                    flag |= 1 << i;
                    Class<?> paramType = this.parameters[i].getType();
                    if (paramType.isPrimitive()) {
                        args[i] = TypeUtils.getDefaultValue(paramType);
                    }
                }
                int n = i + 1;
                if (n % 32 == 0 || n == size) {
                    args[size + i / 32] = flag;
                    flag = 0;
                }
                i = n;
            }
        } else {
            for (i = 0; i < size; ++i) {
                Parameter parameter = this.parameters[i];
                Class<?> paramClass = parameter.getType();
                Type paramType = parameter.getParameterizedType();
                Object arg = values.get(this.hashCodes[i]);
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramClass);
                } else if (!paramClass.isInstance(arg)) {
                    arg = TypeUtils.cast(arg, paramClass);
                } else if (paramType instanceof ParameterizedType) {
                    arg = TypeUtils.cast(arg, paramType);
                }
                args[i] = arg;
            }
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new JSONException("invoke constructor error, " + this.constructor, e);
        }
    }
}

