/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.PollingHeader;
import org.apache.rocketmq.broker.longpolling.PollingResult;
import org.apache.rocketmq.broker.longpolling.PopRequest;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCallback;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.MessageFilter;

public class PopLongPollingService
extends ServiceThread {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final NettyRequestProcessor processor;
    private final Cache<String, ConcurrentHashMap<String, Byte>> topicCidMap;
    private final Cache<String, ConcurrentSkipListSet<PopRequest>> pollingMap;
    private long lastCleanTime = 0L;
    private final AtomicLong totalPollingNum = new AtomicLong(0L);
    private final boolean notifyLast;

    public PopLongPollingService(BrokerController brokerController, NettyRequestProcessor processor, boolean notifyLast) {
        this.brokerController = brokerController;
        this.processor = processor;
        this.topicCidMap = Caffeine.newBuilder().maximumSize((long)this.brokerController.getBrokerConfig().getPopPollingMapSize() * 2L).expireAfterAccess((long)this.brokerController.getBrokerConfig().getPopPollingMapExpireTimeSeconds(), TimeUnit.SECONDS).build();
        this.pollingMap = Caffeine.newBuilder().maximumSize((long)this.brokerController.getBrokerConfig().getPopPollingMapSize()).expireAfterAccess((long)this.brokerController.getBrokerConfig().getPopPollingMapExpireTimeSeconds(), TimeUnit.SECONDS).build();
        this.notifyLast = notifyLast;
    }

    public String getServiceName() {
        if (this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + PopLongPollingService.class.getSimpleName();
        }
        return PopLongPollingService.class.getSimpleName();
    }

    public void run() {
        int i = 0;
        while (!this.stopped) {
            try {
                this.waitForRunning(20L);
                ++i;
                if (this.pollingMap.estimatedSize() == 0L) continue;
                long tmpTotalPollingNum = 0L;
                for (Map.Entry entry : this.pollingMap.asMap().entrySet()) {
                    PopRequest first;
                    String key = (String)entry.getKey();
                    ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                    if (popQ == null) continue;
                    while ((first = (PopRequest)popQ.pollFirst()) != null) {
                        if (!first.isTimeout()) {
                            if (popQ.add(first)) break;
                            POP_LOGGER.info("polling, add fail again: {}", (Object)first);
                        }
                        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                            POP_LOGGER.info("timeout , wakeUp polling : {}", (Object)first);
                        }
                        this.totalPollingNum.decrementAndGet();
                        this.wakeUp(first);
                    }
                    if (i < 100) continue;
                    long tmpPollingNum = popQ.size();
                    tmpTotalPollingNum += tmpPollingNum;
                    if (tmpPollingNum <= 100L) continue;
                    POP_LOGGER.info("polling queue {} , size={} ", (Object)key, (Object)tmpPollingNum);
                }
                if (i >= 100) {
                    POP_LOGGER.info("pollingMapSize={},tmpTotalSize={},atomicTotalSize={},diffSize={}", new Object[]{this.pollingMap.estimatedSize(), tmpTotalPollingNum, this.totalPollingNum.get(), Math.abs(this.totalPollingNum.get() - tmpTotalPollingNum)});
                    this.totalPollingNum.set(tmpTotalPollingNum);
                    i = 0;
                }
                if (this.lastCleanTime != 0L && System.currentTimeMillis() - this.lastCleanTime <= 300000L) continue;
                this.cleanUnusedResource();
            }
            catch (Throwable e) {
                POP_LOGGER.error("checkPolling error", e);
            }
        }
        try {
            for (Map.Entry entry : this.pollingMap.asMap().entrySet()) {
                PopRequest first;
                ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                while ((first = (PopRequest)popQ.pollFirst()) != null) {
                    this.wakeUp(first);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void notifyMessageArrivingWithRetryTopic(String topic, int queueId) {
        this.notifyMessageArrivingWithRetryTopic(topic, queueId, -1L, null, 0L, null, null);
    }

    public void notifyMessageArrivingWithRetryTopic(String topic, int queueId, long offset, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        if (NamespaceUtil.isRetryTopic((String)topic)) {
            this.notifyMessageArrivingFromRetry(topic, queueId, tagsCode, msgStoreTime, filterBitMap, properties);
        } else {
            this.notifyMessageArriving(topic, queueId, offset, tagsCode, msgStoreTime, filterBitMap, properties);
        }
    }

    private void notifyMessageArrivingFromRetry(String topic, int queueId, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        String prefix = "%RETRY%";
        String originGroup = properties.get("ORIGIN_GROUP");
        if (StringUtils.isBlank((CharSequence)originGroup)) {
            return;
        }
        int originTopicStartIndex = prefix.length() + originGroup.length() + 1;
        if (topic.length() <= originTopicStartIndex) {
            return;
        }
        String originTopic = topic.substring(originTopicStartIndex);
        if (queueId >= 0) {
            this.notifyMessageArriving(originTopic, -1, originGroup, true, tagsCode, msgStoreTime, filterBitMap, properties);
        }
        this.notifyMessageArriving(originTopic, queueId, originGroup, true, tagsCode, msgStoreTime, filterBitMap, properties);
    }

    public void notifyMessageArriving(String topic, int queueId, long offset, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        ConcurrentHashMap cids = (ConcurrentHashMap)this.topicCidMap.getIfPresent((Object)topic);
        if (cids == null) {
            return;
        }
        long interval = this.brokerController.getBrokerConfig().getPopLongPollingForceNotifyInterval();
        boolean force = interval > 0L && offset % interval == 0L;
        for (Map.Entry cid : cids.entrySet()) {
            if (queueId >= 0) {
                this.notifyMessageArriving(topic, -1, (String)cid.getKey(), force, tagsCode, msgStoreTime, filterBitMap, properties);
            }
            this.notifyMessageArriving(topic, queueId, (String)cid.getKey(), force, tagsCode, msgStoreTime, filterBitMap, properties);
        }
    }

    public boolean notifyMessageArriving(String topic, int queueId, String cid, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        return this.notifyMessageArriving(topic, queueId, cid, false, tagsCode, msgStoreTime, filterBitMap, properties, null);
    }

    public boolean notifyMessageArriving(String topic, int queueId, String cid, boolean force, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        return this.notifyMessageArriving(topic, queueId, cid, force, tagsCode, msgStoreTime, filterBitMap, properties, null);
    }

    public boolean notifyMessageArriving(String topic, int queueId, String cid, boolean force, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties, CommandCallback callback) {
        ConcurrentSkipListSet remotingCommands = (ConcurrentSkipListSet)this.pollingMap.getIfPresent((Object)KeyBuilder.buildPollingKey((String)topic, (String)cid, (int)queueId));
        if (remotingCommands == null || remotingCommands.isEmpty()) {
            return false;
        }
        PopRequest popRequest = this.pollRemotingCommands(remotingCommands);
        if (popRequest == null) {
            return false;
        }
        if (!force && popRequest.getMessageFilter() != null && popRequest.getSubscriptionData() != null) {
            boolean match = popRequest.getMessageFilter().isMatchedByConsumeQueue(tagsCode, new ConsumeQueueExt.CqExtUnit(tagsCode, msgStoreTime, filterBitMap));
            if (match && properties != null) {
                match = popRequest.getMessageFilter().isMatchedByCommitLog(null, properties);
            }
            if (!match) {
                remotingCommands.add(popRequest);
                this.totalPollingNum.incrementAndGet();
                return false;
            }
        }
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("lock release, new msg arrive, wakeUp: {}", (Object)popRequest);
        }
        return this.wakeUp(popRequest, callback);
    }

    public boolean wakeUp(PopRequest request) {
        return this.wakeUp(request, null);
    }

    public boolean wakeUp(PopRequest request, CommandCallback callback) {
        if (request == null || !request.complete()) {
            return false;
        }
        if (callback != null && request.getRemotingCommand() != null) {
            if (request.getRemotingCommand().getCallbackList() == null) {
                request.getRemotingCommand().setCallbackList(new ArrayList());
            }
            request.getRemotingCommand().getCallbackList().add(callback);
        }
        if (!request.getCtx().channel().isActive()) {
            return false;
        }
        Runnable run = () -> {
            try {
                RemotingCommand response = this.processor.processRequest(request.getCtx(), request.getRemotingCommand());
                if (response != null) {
                    response.setOpaque(request.getRemotingCommand().getOpaque());
                    response.markResponseType();
                    NettyRemotingAbstract.writeResponse((Channel)request.getChannel(), (RemotingCommand)request.getRemotingCommand(), (RemotingCommand)response, future -> {
                        if (!future.isSuccess()) {
                            POP_LOGGER.error("ProcessRequestWrapper response to {} failed", (Object)request.getChannel().remoteAddress(), (Object)future.cause());
                            POP_LOGGER.error(request.toString());
                            POP_LOGGER.error(response.toString());
                        }
                    }, (RemotingMetricsManager)this.brokerController.getBrokerMetricsManager().getRemotingMetricsManager());
                }
            }
            catch (Exception e1) {
                POP_LOGGER.error("ExecuteRequestWhenWakeup run", (Throwable)e1);
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, request.getChannel(), request.getRemotingCommand()));
        return true;
    }

    public PollingResult polling(ChannelHandlerContext ctx, RemotingCommand remotingCommand, PollingHeader requestHeader) {
        return this.polling(ctx, remotingCommand, requestHeader, null, null);
    }

    public PollingResult polling(ChannelHandlerContext ctx, RemotingCommand remotingCommand, PollingHeader requestHeader, SubscriptionData subscriptionData, MessageFilter messageFilter) {
        boolean isFull;
        if (requestHeader.getPollTime() <= 0L || this.isStopped()) {
            return PollingResult.NOT_POLLING;
        }
        ConcurrentHashMap cids = (ConcurrentHashMap)this.topicCidMap.get((Object)requestHeader.getTopic(), key -> new ConcurrentHashMap());
        cids.putIfAbsent(requestHeader.getConsumerGroup(), (byte)-128);
        long expired = requestHeader.getBornTime() + requestHeader.getPollTime();
        PopRequest request = new PopRequest(remotingCommand, ctx, expired, subscriptionData, messageFilter);
        boolean bl = isFull = this.totalPollingNum.get() >= this.brokerController.getBrokerConfig().getMaxPopPollingSize();
        if (isFull) {
            POP_LOGGER.info("polling {}, result POLLING_FULL, total:{}", (Object)remotingCommand, (Object)this.totalPollingNum.get());
            return PollingResult.POLLING_FULL;
        }
        boolean isTimeout = request.isTimeout();
        if (isTimeout) {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_TIMEOUT", (Object)remotingCommand);
            }
            return PollingResult.POLLING_TIMEOUT;
        }
        String key2 = KeyBuilder.buildPollingKey((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup(), (int)requestHeader.getQueueId());
        ConcurrentSkipListSet queue = (ConcurrentSkipListSet)this.pollingMap.get((Object)key2, k -> new ConcurrentSkipListSet<PopRequest>(PopRequest.COMPARATOR));
        int size = queue.size();
        if (size > this.brokerController.getBrokerConfig().getPopPollingSize()) {
            POP_LOGGER.info("polling {}, result POLLING_FULL, singleSize:{}", (Object)remotingCommand, (Object)size);
            return PollingResult.POLLING_FULL;
        }
        if (queue.add(request)) {
            remotingCommand.setSuspended(true);
            this.totalPollingNum.incrementAndGet();
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_SUC", (Object)remotingCommand);
            }
            return PollingResult.POLLING_SUC;
        }
        POP_LOGGER.info("polling {}, result POLLING_FULL, add fail, {}", (Object)request, (Object)queue);
        return PollingResult.POLLING_FULL;
    }

    public Cache<String, ConcurrentSkipListSet<PopRequest>> getPollingMap() {
        return this.pollingMap;
    }

    public Cache<String, ConcurrentHashMap<String, Byte>> getTopicCidMap() {
        return this.topicCidMap;
    }

    private void cleanUnusedResource() {
        try {
            Map.Entry entry;
            Iterator topicCidMapIter = this.topicCidMap.asMap().entrySet().iterator();
            while (topicCidMapIter.hasNext()) {
                entry = topicCidMapIter.next();
                String topic = (String)entry.getKey();
                if (this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                    POP_LOGGER.info("remove nonexistent topic {} in topicCidMap!", (Object)topic);
                    topicCidMapIter.remove();
                    continue;
                }
                Iterator cidMapIter = ((ConcurrentHashMap)entry.getValue()).entrySet().iterator();
                while (cidMapIter.hasNext()) {
                    Map.Entry cidEntry = cidMapIter.next();
                    String cid = (String)cidEntry.getKey();
                    if (this.brokerController.getSubscriptionGroupManager().containsSubscriptionGroup(cid)) continue;
                    POP_LOGGER.info("remove nonexistent subscription group {} of topic {} in topicCidMap!", (Object)cid, (Object)topic);
                    cidMapIter.remove();
                }
            }
            Iterator pollingMapIter = this.pollingMap.asMap().entrySet().iterator();
            while (pollingMapIter.hasNext()) {
                String[] keyArray;
                entry = pollingMapIter.next();
                if (entry.getKey() == null || (keyArray = ((String)entry.getKey()).split("@")).length != 3) continue;
                String topic = keyArray[0];
                String cid = keyArray[1];
                if (this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                    POP_LOGGER.info("remove nonexistent topic {} in pollingMap!", (Object)topic);
                    pollingMapIter.remove();
                    continue;
                }
                if (this.brokerController.getSubscriptionGroupManager().containsSubscriptionGroup(cid)) continue;
                POP_LOGGER.info("remove nonexistent subscription group {} of topic {} in pollingMap!", (Object)cid, (Object)topic);
                pollingMapIter.remove();
            }
        }
        catch (Throwable e) {
            POP_LOGGER.error("cleanUnusedResource", e);
        }
        this.lastCleanTime = System.currentTimeMillis();
    }

    private PopRequest pollRemotingCommands(ConcurrentSkipListSet<PopRequest> remotingCommands) {
        PopRequest popRequest;
        if (remotingCommands == null || remotingCommands.isEmpty()) {
            return null;
        }
        do {
            popRequest = this.notifyLast ? remotingCommands.pollLast() : remotingCommands.pollFirst();
            this.totalPollingNum.decrementAndGet();
        } while (popRequest != null && !popRequest.getChannel().isActive());
        return popRequest;
    }
}

