/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer.rocksdb;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import com.google.common.util.concurrent.RateLimiter;
import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.StoreUtil;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.metrics.DefaultStoreMetricsManager;
import org.apache.rocketmq.store.metrics.StoreMetricsManager;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.rocksdb.MessageRocksDBStorage;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.timer.TimerMetrics;
import org.apache.rocketmq.store.timer.rocksdb.Timeline;
import org.apache.rocketmq.store.timer.rocksdb.TimerRocksDBRecord;
import org.apache.rocketmq.store.util.PerfCounter;

public class TimerMessageRocksDBStore {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final String SCAN_SYS_TOPIC = "scanSysTopic";
    private static final String SCAN_SYS_TOPIC_MISS = "scanSysTopicMiss";
    private static final String OUT_BIZ_MESSAGE = "outBizMsg";
    private static final String ROLL_LABEL = "R";
    private static final int PUT_OK = 0;
    private static final int PUT_NEED_RETRY = 1;
    private static final int PUT_NO_RETRY = 2;
    private static final int MAX_GET_MSG_TIMES = 3;
    private static final int MAX_PUT_MSG_TIMES = 3;
    private static final int TIME_UP_CAPACITY = 100;
    private static final int ROLL_CAPACITY = 50;
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;
    private static long expirationThresholdMillis = 999L;
    private final AtomicLong readOffset = new AtomicLong(0L);
    private final MessageStore messageStore;
    private final TimerMetrics timerMetrics;
    private final MessageStoreConfig storeConfig;
    private final BrokerStatsManager brokerStatsManager;
    private final MessageRocksDBStorage messageRocksDBStorage;
    private Timeline timeline;
    private TimerSysTopicScanService timerSysTopicScanService;
    private TimerMessageReputService expiredMessageReputService;
    private TimerMessageReputService rollMessageReputService;
    protected long precisionMs;
    private BlockingQueue<List<TimerRocksDBRecord>> expiredMessageQueue;
    private BlockingQueue<List<TimerRocksDBRecord>> rollMessageQueue;
    protected final PerfCounter.Ticks perfCounterTicks = new PerfCounter.Ticks(log);
    private Function<MessageExtBrokerInner, PutMessageResult> escapeBridgeHook;
    private ThreadLocal<ByteBuffer> bufferLocal = null;

    public TimerMessageRocksDBStore(MessageStore messageStore, TimerMetrics timerMetrics, BrokerStatsManager brokerStatsManager) {
        this.messageStore = messageStore;
        this.storeConfig = messageStore.getMessageStoreConfig();
        this.precisionMs = this.storeConfig.getTimerRocksDBPrecisionMs() < 100L ? 1000L : this.storeConfig.getTimerRocksDBPrecisionMs();
        expirationThresholdMillis = this.precisionMs - 1L;
        this.messageRocksDBStorage = messageStore.getMessageRocksDBStorage();
        this.timerMetrics = timerMetrics;
        this.brokerStatsManager = brokerStatsManager;
        this.bufferLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(this.storeConfig.getMaxMessageSize()));
    }

    public synchronized boolean load() {
        this.initService();
        boolean result = this.timerMetrics.load();
        log.info("TimerMessageRocksDBStore load result: {}", (Object)result);
        return result;
    }

    public synchronized void start() {
        if (this.state == 1) {
            return;
        }
        long commitOffsetFile = null != this.messageStore.getTimerMessageStore() ? this.messageStore.getTimerMessageStore().getCommitQueueOffset() : 0L;
        long commitOffsetRocksDB = this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.SYS_TOPIC_SCAN_OFFSET_CHECK_POINT);
        long maxCommitOffset = Math.max(commitOffsetFile, commitOffsetRocksDB);
        this.readOffset.set(maxCommitOffset);
        this.expiredMessageReputService.start();
        this.rollMessageReputService.start();
        this.timeline.start();
        this.timerSysTopicScanService.start();
        this.state = 1;
        log.info("TimerMessageRocksDBStore start success, start commitOffsetFile: {}, commitOffsetRocksDB: {}, readOffset: {}", new Object[]{commitOffsetFile, commitOffsetRocksDB, this.readOffset.get()});
    }

    public synchronized boolean restart() {
        try {
            this.storeConfig.setTimerStopEnqueue(true);
            if (this.state == 1 && !this.storeConfig.isTimerRocksDBStopScan()) {
                log.info("restart TimerMessageRocksDBStore has been running");
                return true;
            }
            if (this.state == 1 && this.storeConfig.isTimerRocksDBStopScan()) {
                long commitOffsetFile = null != this.messageStore.getTimerMessageStore() ? this.messageStore.getTimerMessageStore().getCommitQueueOffset() : 0L;
                long commitOffsetRocksDB = this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.SYS_TOPIC_SCAN_OFFSET_CHECK_POINT);
                long maxCommitOffset = Math.max(commitOffsetFile, commitOffsetRocksDB);
                this.readOffset.set(maxCommitOffset);
                log.info("restart TimerMessageRocksDBStore has been recover running, commitOffsetFile: {}, commitOffsetRocksDB: {}, readOffset: {}", new Object[]{commitOffsetFile, commitOffsetRocksDB, this.readOffset.get()});
            } else {
                this.load();
                this.start();
            }
            this.storeConfig.setTimerRocksDBEnable(true);
            this.storeConfig.setTimerRocksDBStopScan(false);
            return true;
        }
        catch (Exception e) {
            logError.error("TimerMessageRocksDBStore restart error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void shutdown() {
        if (this.state != 1 || this.state == 2) {
            return;
        }
        if (null != this.timerSysTopicScanService) {
            this.timerSysTopicScanService.shutdown();
        }
        if (null != this.timeline) {
            this.timeline.shutDown();
        }
        if (null != this.expiredMessageReputService) {
            this.expiredMessageReputService.shutdown();
        }
        if (null != this.rollMessageReputService) {
            this.rollMessageReputService.shutdown();
        }
        this.state = 2;
        log.info("TimerMessageRocksDBStore shutdown success");
    }

    public void putRealTopicMessage(MessageExt msg) {
        if (null == msg) {
            logError.error("putRealTopicMessage msg is null");
            return;
        }
        MessageExtBrokerInner messageExtBrokerInner = this.convertMessage(msg);
        if (null == messageExtBrokerInner) {
            logError.error("putRealTopicMessage error, messageExtBrokerInner is null");
            return;
        }
        this.doPut(messageExtBrokerInner);
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public TimerMetrics getTimerMetrics() {
        return this.timerMetrics;
    }

    public BrokerStatsManager getBrokerStatsManager() {
        return this.brokerStatsManager;
    }

    public AtomicLong getReadOffset() {
        return this.readOffset;
    }

    public BlockingQueue<List<TimerRocksDBRecord>> getExpiredMessageQueue() {
        return this.expiredMessageQueue;
    }

    public BlockingQueue<List<TimerRocksDBRecord>> getRollMessageQueue() {
        return this.rollMessageQueue;
    }

    public long getCommitOffsetInRocksDB() {
        if (null == this.messageRocksDBStorage || !this.storeConfig.isTimerRocksDBEnable()) {
            return 0L;
        }
        return this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.SYS_TOPIC_SCAN_OFFSET_CHECK_POINT);
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    private void initService() {
        if (this.storeConfig.isTimerEnableDisruptor()) {
            this.expiredMessageQueue = new DisruptorBlockingQueue(100);
            this.rollMessageQueue = new DisruptorBlockingQueue(50);
        } else {
            this.expiredMessageQueue = new LinkedBlockingDeque<List<TimerRocksDBRecord>>(100);
            this.rollMessageQueue = new LinkedBlockingDeque<List<TimerRocksDBRecord>>(50);
        }
        this.expiredMessageReputService = new TimerMessageReputService(this.expiredMessageQueue, this.storeConfig.getTimerRocksDBTimeExpiredMaxTps(), true);
        this.rollMessageReputService = new TimerMessageReputService(this.rollMessageQueue, this.storeConfig.getTimerRocksDBRollMaxTps(), false);
        this.timeline = new Timeline(this.messageStore, this.messageRocksDBStorage, this, this.timerMetrics);
        this.timerSysTopicScanService = new TimerSysTopicScanService();
    }

    private MessageExtBrokerInner convertMessage(MessageExt msgExt) {
        if (null == msgExt) {
            logError.error("convertMessage msgExt is null");
            return null;
        }
        MessageExtBrokerInner msgInner = null;
        try {
            msgInner = new MessageExtBrokerInner();
            msgInner.setBody(msgExt.getBody());
            msgInner.setFlag(msgExt.getFlag());
            msgInner.setTags(msgExt.getTags());
            msgInner.setSysFlag(msgExt.getSysFlag());
            TopicFilterType topicFilterType = MessageExt.parseTopicFilterType((int)msgInner.getSysFlag());
            long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
            msgInner.setTagsCode(tagsCodeValue);
            msgInner.setBornTimestamp(msgExt.getBornTimestamp());
            msgInner.setBornHost(msgExt.getBornHost());
            msgInner.setStoreHost(msgExt.getStoreHost());
            msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
            msgInner.setWaitStoreMsgOK(false);
            MessageAccessor.setProperties((Message)msgInner, (Map)MessageAccessor.deepCopyProperties((Map)msgExt.getProperties()));
            if (this.isNeedRoll((MessageExt)msgInner)) {
                msgInner.setTopic(msgExt.getTopic());
                msgInner.setQueueId(msgExt.getQueueId());
                msgInner.getProperties().put("TIMER_ROLL_LABEL", ROLL_LABEL);
            } else {
                msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
                msgInner.setQueueId(Integer.parseInt(msgInner.getProperty("REAL_QID")));
                MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_TOPIC");
                MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_QID");
                MessageAccessor.clearProperty((Message)msgInner, (String)"TIMER_ROLL_LABEL");
            }
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        }
        catch (Exception e) {
            logError.error("convertMessage error: {}", (Object)e.getMessage());
            return null;
        }
        return msgInner;
    }

    private MessageExt getMessageByCommitOffset(long offsetPy, int sizePy) {
        if (offsetPy < 0L || sizePy <= 0 || sizePy > this.storeConfig.getMaxMessageSize()) {
            logError.error("getMessageByCommitOffset param error, offsetPy: {}, sizePy: {}, maxMsgSize: {}", new Object[]{offsetPy, sizePy, this.storeConfig.getMaxMessageSize()});
            return null;
        }
        if (sizePy > this.bufferLocal.get().limit()) {
            this.bufferLocal.remove();
            this.bufferLocal.set(ByteBuffer.allocate(sizePy));
        }
        for (int i = 0; i < 3; ++i) {
            MessageExt msgExt = StoreUtil.getMessage(offsetPy, sizePy, this.messageStore, this.bufferLocal.get());
            if (null != msgExt) {
                return msgExt;
            }
            log.warn("Fail to read msg from commitLog offsetPy: {} sizePy: {}", (Object)offsetPy, (Object)sizePy);
        }
        return null;
    }

    private boolean isNeedRoll(MessageExt messageExt) {
        try {
            String property = messageExt.getProperty("TIMER_OUT_MS");
            if (StringUtils.isEmpty((CharSequence)property)) {
                return false;
            }
            if (!TimerMessageRocksDBStore.isExpired(Long.parseLong(property))) {
                return true;
            }
        }
        catch (Exception e) {
            logError.error("isNeedRoll error : {}", (Object)e.getMessage());
        }
        return false;
    }

    private Long getDelayTime(MessageExt msgExt) {
        if (null == msgExt) {
            logError.error("getDelayTime msgExt is null");
            return null;
        }
        String delayTimeStr = msgExt.getProperty("TIMER_OUT_MS");
        if (StringUtils.isEmpty((CharSequence)delayTimeStr)) {
            logError.error("getDelayTime is empty, queueOffset: {}, delayTimeStr: {}", (Object)msgExt.getQueueOffset(), (Object)delayTimeStr);
            return null;
        }
        try {
            return Long.parseLong(delayTimeStr);
        }
        catch (Exception e) {
            logError.error("getDelayTime parse to long error : {}", (Object)e.getMessage());
            return null;
        }
    }

    private int doPut(MessageExtBrokerInner message) {
        if (null == message) {
            logError.error("doPut message is null");
            return 2;
        }
        if (null != message.getProperty("TIMER_DEL_UNIQKEY")) {
            logError.warn("Trying do put delete timer msg:[{}]", (Object)message);
            return 2;
        }
        PutMessageResult putMessageResult = null;
        putMessageResult = this.escapeBridgeHook != null ? this.escapeBridgeHook.apply(message) : this.messageStore.putMessage(message);
        if (null != putMessageResult && null != putMessageResult.getPutMessageStatus()) {
            switch (putMessageResult.getPutMessageStatus()) {
                case PUT_OK: {
                    if (null != this.brokerStatsManager) {
                        this.brokerStatsManager.incTopicPutNums(message.getTopic(), 1, 1);
                        if (null != putMessageResult.getAppendMessageResult()) {
                            this.brokerStatsManager.incTopicPutSize(message.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
                        }
                        this.brokerStatsManager.incBrokerPutNums(message.getTopic(), 1);
                    }
                    return 0;
                }
                case MESSAGE_ILLEGAL: 
                case PROPERTIES_SIZE_EXCEEDED: 
                case WHEEL_TIMER_NOT_ENABLE: 
                case WHEEL_TIMER_MSG_ILLEGAL: {
                    return 2;
                }
                case SERVICE_NOT_AVAILABLE: 
                case FLUSH_DISK_TIMEOUT: 
                case FLUSH_SLAVE_TIMEOUT: 
                case OS_PAGE_CACHE_BUSY: 
                case CREATE_MAPPED_FILE_FAILED: 
                case SLAVE_NOT_AVAILABLE: {
                    return 1;
                }
            }
            if (this.storeConfig.isTimerSkipUnknownError()) {
                logError.warn("Skipping message due to unknown error, msg: {}", (Object)message);
                return 2;
            }
            return 1;
        }
        return 1;
    }

    public static boolean isExpired(long delayedTime) {
        return delayedTime <= System.currentTimeMillis() + expirationThresholdMillis;
    }

    public void registerEscapeBridgeHook(Function<MessageExtBrokerInner, PutMessageResult> escapeBridgeHook) {
        this.escapeBridgeHook = escapeBridgeHook;
    }

    private String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    private class TimerMessageReputService
    extends ServiceThread {
        private final Logger log = TimerMessageRocksDBStore.access$100();
        private final BlockingQueue<List<TimerRocksDBRecord>> queue;
        private final RateLimiter rateLimiter;
        private final boolean writeCheckPoint;
        ExecutorService executor = new ThreadPoolExecutor(6, 6, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.CallerRunsPolicy());

        public TimerMessageReputService(BlockingQueue<List<TimerRocksDBRecord>> queue, double maxTps, boolean writeCheckPoint) {
            this.queue = queue;
            this.rateLimiter = RateLimiter.create((double)maxTps);
            this.writeCheckPoint = writeCheckPoint;
        }

        public String getServiceName() {
            return TimerMessageRocksDBStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            while (!this.isStopped() || !this.queue.isEmpty()) {
                try {
                    List<TimerRocksDBRecord> trs = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (CollectionUtils.isEmpty(trs)) continue;
                    long start = System.currentTimeMillis();
                    CountDownLatch countDownLatch = new CountDownLatch(trs.size());
                    for (TimerRocksDBRecord record : trs) {
                        this.executor.submit(new Task(countDownLatch, record));
                    }
                    countDownLatch.await();
                    this.log.info("TimerMessageReputService reput messages to commitlog, cost: {}, trs size: {}, checkPoint: {}", new Object[]{System.currentTimeMillis() - start, trs.size(), trs.get(trs.size() - 1).getCheckPoint()});
                    if (!this.writeCheckPoint || CollectionUtils.isEmpty(trs) || trs.get(trs.size() - 1).getCheckPoint() <= 0L) continue;
                    this.log.info("TimerMessageReputService reput messages to commitlog, checkPoint: {}", (Object)trs.get(trs.size() - 1).getCheckPoint());
                    TimerMessageRocksDBStore.this.messageRocksDBStorage.writeCheckPointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.TIMELINE_CHECK_POINT, trs.get(trs.size() - 1).getCheckPoint());
                }
                catch (Exception e) {
                    logError.error("TimerMessageReputService error: {}", (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        private void putMsgWithRetry(MessageExtBrokerInner msg) throws InterruptedException {
            if (null == msg) {
                return;
            }
            for (int retryCount = 0; !this.isStopped() && retryCount <= 3; ++retryCount) {
                int result = TimerMessageRocksDBStore.this.doPut(msg);
                switch (result) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        logError.warn("Skipping message due to unrecoverable error. Msg: {}", (Object)msg);
                        return;
                    }
                }
                if (retryCount == 3) {
                    logError.error("Message processing failed after {} retries. Msg: {}", (Object)retryCount, (Object)msg);
                    return;
                }
                Thread.sleep(100L);
                logError.warn("Retrying to process message. Retry count: {}, Msg: {}", (Object)retryCount, (Object)msg);
            }
        }

        class Task
        implements Callable<Void> {
            private CountDownLatch countDownLatch;
            private TimerRocksDBRecord record;

            public Task(CountDownLatch countDownLatch, TimerRocksDBRecord record) {
                this.countDownLatch = countDownLatch;
                this.record = record;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    TimerMessageRocksDBStore.this.perfCounterTicks.startTick(TimerMessageRocksDBStore.OUT_BIZ_MESSAGE);
                    MessageExt messageExt = this.record.getMessageExt();
                    if (null == messageExt && null == (messageExt = TimerMessageRocksDBStore.this.getMessageByCommitOffset(this.record.getOffsetPy(), this.record.getSizePy()))) {
                        Void void_ = null;
                        return void_;
                    }
                    MessageExtBrokerInner msg = TimerMessageRocksDBStore.this.convertMessage(messageExt);
                    if (null == msg) {
                        Void void_ = null;
                        return void_;
                    }
                    this.record.setUniqKey(MessageClientIDSetter.getUniqID((Message)msg));
                    TimerMessageReputService.this.putMsgWithRetry(msg);
                    TimerMessageRocksDBStore.this.timeline.addMetric((MessageExt)msg, -1);
                    TimerMessageRocksDBStore.this.perfCounterTicks.endTick(TimerMessageRocksDBStore.OUT_BIZ_MESSAGE);
                    TimerMessageReputService.this.rateLimiter.acquire();
                }
                catch (Exception e) {
                    logError.error("TimerMessageReputService running error: {}", (Object)e.getMessage());
                }
                finally {
                    this.countDownLatch.countDown();
                }
                return null;
            }
        }
    }

    private class TimerSysTopicScanService
    extends ServiceThread {
        private final Logger log = TimerMessageRocksDBStore.access$100();

        private TimerSysTopicScanService() {
        }

        public String getServiceName() {
            return TimerMessageRocksDBStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    long waitTime;
                    if (!TimerMessageRocksDBStore.this.storeConfig.isTimerRocksDBEnable() || TimerMessageRocksDBStore.this.storeConfig.isTimerRocksDBStopScan()) {
                        waitTime = TimeUnit.SECONDS.toMillis(10L);
                    } else {
                        this.scanSysTimerTopic();
                        waitTime = 100L;
                    }
                    this.waitForRunning(waitTime);
                }
                catch (Exception e) {
                    logError.error("TimerMessageRocksDBStore error occurred in: {}, error: {}", (Object)this.getServiceName(), (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanSysTimerTopic() {
            ConsumeQueueInterface cq = TimerMessageRocksDBStore.this.messageStore.getConsumeQueue("rmq_sys_wheel_timer", 0);
            if (null == cq) {
                return;
            }
            if (TimerMessageRocksDBStore.this.readOffset.get() < cq.getMinOffsetInQueue()) {
                logError.warn("scanSysTimerTopic readOffset: {} is smaller than minOffsetInQueue: {}, use minOffsetInQueue to scan timer sysTimerTopic", (Object)TimerMessageRocksDBStore.this.readOffset.get(), (Object)cq.getMinOffsetInQueue());
                TimerMessageRocksDBStore.this.readOffset.set(cq.getMinOffsetInQueue());
            } else if (TimerMessageRocksDBStore.this.readOffset.get() > cq.getMaxOffsetInQueue()) {
                logError.warn("scanSysTimerTopic readOffset: {} is bigger than maxOffsetInQueue: {}, use maxOffsetInQueue to scan timer sysTimerTopic", (Object)TimerMessageRocksDBStore.this.readOffset.get(), (Object)cq.getMaxOffsetInQueue());
                TimerMessageRocksDBStore.this.readOffset.set(cq.getMaxOffsetInQueue());
            }
            ReferredIterator<CqUnit> iterator = null;
            try {
                iterator = cq.iterateFrom(TimerMessageRocksDBStore.this.readOffset.get());
                if (null == iterator) {
                    return;
                }
                while (iterator.hasNext()) {
                    TimerMessageRocksDBStore.this.perfCounterTicks.startTick(TimerMessageRocksDBStore.SCAN_SYS_TOPIC);
                    try {
                        CqUnit cqUnit = (CqUnit)iterator.next();
                        if (null == cqUnit) {
                            logError.error("scanSysTimerTopic cqUnit is null, readOffset: {}", (Object)TimerMessageRocksDBStore.this.readOffset.get());
                            break;
                        }
                        long offsetPy = cqUnit.getPos();
                        int sizePy = cqUnit.getSize();
                        long queueOffset = cqUnit.getQueueOffset();
                        MessageExt msgExt = TimerMessageRocksDBStore.this.getMessageByCommitOffset(offsetPy, sizePy);
                        if (null == msgExt) {
                            TimerMessageRocksDBStore.this.perfCounterTicks.getCounter(TimerMessageRocksDBStore.SCAN_SYS_TOPIC_MISS);
                            break;
                        }
                        Long delayedTime = TimerMessageRocksDBStore.this.getDelayTime(msgExt);
                        if (null == delayedTime) {
                            TimerMessageRocksDBStore.this.readOffset.incrementAndGet();
                            continue;
                        }
                        if (TimerMessageRocksDBStore.isExpired(delayedTime)) {
                            TimerMessageRocksDBStore.this.putRealTopicMessage(msgExt);
                            TimerMessageRocksDBStore.this.readOffset.incrementAndGet();
                            continue;
                        }
                        TimerRocksDBRecord timerRecord = new TimerRocksDBRecord(delayedTime, MessageClientIDSetter.getUniqID((Message)msgExt), offsetPy, sizePy, queueOffset, msgExt);
                        TimerMessageRocksDBStore.this.timeline.putRecord(timerRecord);
                        TimerMessageRocksDBStore.this.readOffset.incrementAndGet();
                        StoreMetricsManager metricsManager = TimerMessageRocksDBStore.this.messageStore.getStoreMetricsManager();
                        if (!(metricsManager instanceof DefaultStoreMetricsManager)) continue;
                        DefaultStoreMetricsManager defaultMetricsManager = (DefaultStoreMetricsManager)metricsManager;
                        Attributes attributes = defaultMetricsManager.newAttributesBuilder().put("topic", msgExt.getProperty("REAL_TOPIC")).build();
                        defaultMetricsManager.getTimerMessageSetLatency().record((delayedTime - msgExt.getBornTimestamp()) / 1000L, attributes);
                    }
                    catch (Exception e) {
                        logError.error("Unknown error in scan the system topic error: {}", (Object)e.getMessage());
                    }
                    finally {
                        TimerMessageRocksDBStore.this.perfCounterTicks.endTick(TimerMessageRocksDBStore.SCAN_SYS_TOPIC);
                    }
                }
            }
            catch (Exception e) {
                logError.error("scanSysTimerTopic throw Unknown exception. {}", (Object)e.getMessage());
            }
            finally {
                if (iterator != null) {
                    iterator.release();
                }
            }
        }
    }
}

