/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import org.apache.royale.compiler.common.ASImportTarget;
import org.apache.royale.compiler.common.IImportTarget;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.internal.tree.as.FullNameNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.problems.DuplicateImportAliasProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IImportNode;

public class ImportNode
extends FixedChildrenNode
implements IImportNode {
    protected ExpressionNodeBase targetImportNode;
    protected IImportNode.ImportKind importKind;
    protected String importAlias;

    public static ImportNode buildImportNode(String qname) {
        LinkedList<ExpressionNodeBase> nodeList = new LinkedList<ExpressionNodeBase>();
        for (String s : qname.split("\\.")) {
            nodeList.add(new IdentifierNode(s));
        }
        ASToken dotToken = new ASToken(36, -1, -1, -1, -1, ".");
        while (nodeList.size() > 1) {
            ExpressionNodeBase first = (ExpressionNodeBase)nodeList.removeFirst();
            ExpressionNodeBase second = (ExpressionNodeBase)nodeList.removeFirst();
            nodeList.addFirst(new FullNameNode(first, dotToken, second));
        }
        ImportNode importNode = new ImportNode((ExpressionNodeBase)nodeList.getFirst());
        return importNode;
    }

    public static String makeWildcardName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(0, lastDot) + ".*";
        }
        return name;
    }

    public ImportNode(ExpressionNodeBase targetImportNode) {
        this.setImportTarget(targetImportNode);
        this.importKind = IImportNode.ImportKind.AS_SCOPED_IMPORT;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ImportID;
    }

    @Override
    public int getChildCount() {
        return this.targetImportNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.targetImportNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.targetImportNode != null) {
            this.targetImportNode.normalize(fillInOffsets);
            this.targetImportNode.setParent(this);
        }
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        this.setChildren(fillInOffsets);
        super.normalize(fillInOffsets);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            if (this.importAlias != null) {
                if (scope.hasImportAlias(this.importAlias)) {
                    FileNode fileNode = (FileNode)this.getAncestorOfType(FileNode.class);
                    fileNode.addProblem(new DuplicateImportAliasProblem(this, this.getImportAlias()));
                } else {
                    scope.addImport(this.getImportName(), this.getImportAlias());
                }
            } else {
                scope.addImport(this.getImportName());
            }
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getImportName());
        sb.append('\"');
        return true;
    }

    @Override
    public IImportNode.ImportKind getImportKind() {
        if (this.getAbsoluteStart() == this.getAbsoluteEnd()) {
            return IImportNode.ImportKind.IMPLICIT_IMPORT;
        }
        return this.importKind;
    }

    @Override
    public IExpressionNode getImportNameNode() {
        return this.targetImportNode;
    }

    @Override
    public String getImportName() {
        return this.targetImportNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.targetImportNode)).getName() : "";
    }

    @Override
    public IImportTarget getImportTarget() {
        return ASImportTarget.get(this.getWorkspace(), this.getImportName());
    }

    @Override
    public boolean isWildcardImport() {
        String targetPackage = this.getImportName();
        return targetPackage.endsWith(".") || targetPackage.endsWith("*");
    }

    @Override
    public IDefinition resolveImport(ICompilerProject project) {
        if (this.isWildcardImport()) {
            return null;
        }
        String importName = this.getImportName();
        IResolvedQualifiersReference importReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), importName);
        ASScope scope = (ASScope)this.getScopeNode().getScope();
        return importReference.resolve(project, scope, null, true);
    }

    public void setImportKind(IImportNode.ImportKind importKind) {
        this.importKind = importKind;
    }

    public void setImportTarget(ExpressionNodeBase targetImportNode) {
        this.targetImportNode = targetImportNode;
        if (targetImportNode != null) {
            this.setEnd(targetImportNode.getAbsoluteEnd());
            this.setEndLine(targetImportNode.getEndLine());
            this.setEndColumn(targetImportNode.getEndColumn());
        }
    }

    @Override
    public String getImportAlias() {
        return this.importAlias;
    }

    public void setImportAlias(String importAlias) {
        this.importAlias = importAlias;
    }
}

