/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ijs.ClassUtil;
import com.google.javascript.jscomp.ijs.FileInfo;
import com.google.javascript.jscomp.ijs.PotentialDeclaration;
import com.google.javascript.rhino.Node;

abstract class ProcessConstJsdocCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final FileInfo currentFile;

    ProcessConstJsdocCallback(FileInfo currentFile) {
        this.currentFile = currentFile;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getToken()) {
            case CLASS: {
                if (!NodeUtil.isStatementParent(parent)) break;
                this.currentFile.recordNameDeclaration(n.getFirstChild());
                break;
            }
            case FUNCTION: {
                if (NodeUtil.isStatementParent(parent)) {
                    this.currentFile.recordNameDeclaration(n.getFirstChild());
                    break;
                }
                if (!ClassUtil.isClassMethod(n) || !ClassUtil.hasNamedClass(n)) break;
                this.currentFile.recordMethod(n);
                break;
            }
            case EXPR_RESULT: {
                Node expr = n.getFirstChild();
                switch (expr.getToken()) {
                    case CALL: {
                        Node callee = expr.getFirstChild();
                        if (callee.matchesQualifiedName("goog.provide")) {
                            this.currentFile.markProvided(expr.getLastChild().getString());
                            break block0;
                        }
                        if (callee.matchesQualifiedName("goog.require")) {
                            this.currentFile.recordImport(expr.getLastChild().getString());
                            break block0;
                        }
                        if (!callee.matchesQualifiedName("goog.define")) break block0;
                        this.currentFile.recordDefine(expr);
                        break block0;
                    }
                    case ASSIGN: {
                        Node lhs = expr.getFirstChild();
                        this.currentFile.recordNameDeclaration(lhs);
                        this.processDeclarationWithRhs(t, lhs);
                        break block0;
                    }
                    case GETPROP: {
                        this.currentFile.recordNameDeclaration(expr);
                        break block0;
                    }
                }
                throw new RuntimeException("Unexpected declaration: " + expr);
            }
            case VAR: 
            case CONST: 
            case LET: {
                Preconditions.checkState(n.hasOneChild(), n);
                this.recordNameDeclaration(n);
                if (!n.getFirstChild().isName() || !n.getFirstChild().hasChildren()) break;
                this.processDeclarationWithRhs(t, n.getFirstChild());
                break;
            }
            case STRING_KEY: {
                if (!parent.isObjectLit() || !n.hasOneChild()) break;
                this.processDeclarationWithRhs(t, n);
                this.currentFile.recordStringKeyDeclaration(n);
                break;
            }
        }
    }

    private void recordNameDeclaration(Node decl) {
        Preconditions.checkArgument(NodeUtil.isNameDeclaration(decl));
        Node rhs = decl.getFirstChild().getLastChild();
        boolean isImport = PotentialDeclaration.isImportRhs(rhs);
        for (Node name : NodeUtil.findLhsNodesInNode(decl)) {
            if (isImport) {
                this.currentFile.recordImport(name.getString());
                continue;
            }
            this.currentFile.recordNameDeclaration(name);
        }
    }

    private void processDeclarationWithRhs(NodeTraversal t, Node lhs) {
        Preconditions.checkArgument(lhs.isQualifiedName() || lhs.isStringKey() || lhs.isDestructuringLhs(), lhs);
        Preconditions.checkState(NodeUtil.getRValueOfLValue(lhs) != null, lhs);
        if (!PotentialDeclaration.isConstToBeInferred(lhs)) {
            return;
        }
        this.processConstWithRhs(t, lhs);
    }

    protected abstract void processConstWithRhs(NodeTraversal var1, Node var2);
}

