/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.TimeoutError;
import com.microsoft.playwright.impl.Waitable;

class WaitableTimeout<T>
implements Waitable<T> {
    private final long deadline;
    private final double timeout;

    WaitableTimeout(double millis) {
        this.timeout = millis;
        this.deadline = System.nanoTime() + (long)millis * 1000000L;
    }

    @Override
    public boolean isDone() {
        return System.nanoTime() > this.deadline;
    }

    @Override
    public T get() {
        String timeoutStr = Double.toString(this.timeout);
        if (timeoutStr.endsWith(".0")) {
            timeoutStr = timeoutStr.substring(0, timeoutStr.length() - 2);
        }
        throw new TimeoutError("Timeout " + timeoutStr + "ms exceeded");
    }

    @Override
    public void dispose() {
    }
}

