/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.QName;

public class NameFormatter {
    public static String toDot(String ns, String n) {
        return ns.length() > 0 ? ns + "." + n : n;
    }

    public static String toColon(String ns, String n) {
        return ns.length() > 0 ? (ns + ":" + n).intern() : n;
    }

    public static String toDot(String n) {
        assert (n.indexOf(47) == -1);
        return NameFormatter.toDot(n, ':');
    }

    public static String toDot(QName qname) {
        return NameFormatter.toDot(qname.getNamespace(), qname.getLocalPart());
    }

    public static String toDot(String n, char delimiter) {
        return n.replace(delimiter, '.');
    }

    public static String toColon(String n) {
        int i;
        Object result = n.startsWith(StandardDefs.CLASS_VECTOR) ? "__AS3__.vec:Vector" + n.substring(StandardDefs.CLASS_VECTOR.length()) : (n.startsWith("__AS3__.vec:Vector") ? n : ((i = NameFormatter.toDot(n).lastIndexOf(46)) > 0 ? (n.substring(0, i) + ":" + n.substring(i + 1)).intern() : n));
        return result;
    }

    public static String toDotStar(String pkg) {
        return pkg + ".*";
    }

    public static String retrievePackageName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i == -1 ? "" : n.substring(0, i);
    }

    public static String normalizePackageName(String n) {
        return n.endsWith("$internal") ? n.substring(0, n.length() - "$internal".length()) : n;
    }

    public static String retrieveClassName(String n) {
        int i;
        String toDot = NameFormatter.toDot(n);
        Object result = toDot.startsWith(StandardDefs.CLASS_VECTOR + ".<") ? "Vector" + n.substring(StandardDefs.CLASS_VECTOR.length() + 1) : ((i = toDot.lastIndexOf(46)) == -1 ? n : n.substring(i + 1));
        return result;
    }

    public static QName toQName(String n) {
        int i = NameFormatter.toDot(n).lastIndexOf(46);
        return i >= 0 ? new QName(n.substring(0, i), n.substring(i + 1)) : new QName("", n);
    }
}

