/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.mxml.MXMLEventHandlerScope;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLEmptyEventHandlerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;

class MXMLEventSpecifierNode
extends MXMLSpecifierNodeBase
implements IMXMLEventSpecifierNode,
IScopedNode {
    private static NodeBase[] NO_AS_NODES = new NodeBase[0];
    private NodeBase[] asNodes = NO_AS_NODES;
    private final MXMLEventHandlerScope scope = new MXMLEventHandlerScope(this);

    MXMLEventSpecifierNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        RoyaleProject project = builder.getProject();
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        this.setSourcePath(attribute.getParent().getParent().getFileSpecification().getPath());
        int startOffsetLocal = attribute.getValueStart();
        MXMLFileScope fileScope = builder.getFileScope();
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
        String filePath = this.getContainingFilePath();
        int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(filePath, startOffsetLocal);
        int startOffsetAbsolute = absoluteOffsets[0];
        IncludeHandler includeHandler = IncludeHandler.createForASTBuilding(builder.getFileSpecificationGetter(), filePath, startOffsetLocal, startOffsetAbsolute);
        includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
        String scriptFragment = attribute.getRawValue();
        if (scriptFragment.isEmpty()) {
            MXMLEmptyEventHandlerProblem problem = new MXMLEmptyEventHandlerProblem(attribute);
            problems.add(problem);
        }
        ScopedBlockNode node = ASParser.parseFragment2(scriptFragment, filePath, 0, attribute.getValueLine(), attribute.getValueColumn(), problems, workspace, builder.getFileNode(), this.scope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.POPULATE_SCOPE), true, includeHandler);
        builder.getFileNode().updateIncludeTreeLastModified(includeHandler.getLastModified());
        this.processHandlerCode(builder, Collections.singletonList(node));
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        String path = builder.getPath();
        MXMLFileNode fileNode = builder.getFileNode();
        this.processHandlerCode(builder, MXMLEventSpecifierNode.processUnitAsAS(builder, tag, path, this.scope, PostProcessStep.POPULATE_SCOPE, fileNode));
    }

    private void processHandlerCode(MXMLTreeBuilder builder, List<ScopedBlockNode> scripts) {
        IReference typeRef = ((DefinitionBase)this.getDefinition()).getTypeReference();
        this.scope.buildEventParameter(typeRef);
        typeRef.resolve(builder.getProject(), this.scope, DependencyType.EXPRESSION, true);
        for (ScopedBlockNode script : scripts) {
            int n = script.getChildCount();
            this.asNodes = new NodeBase[n];
            for (int i = 0; i < n; ++i) {
                NodeBase child;
                this.asNodes[i] = child = (NodeBase)script.getChild(i);
                child.setParent(this);
            }
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLEventSpecifierID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.asNodes != null ? this.asNodes[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.asNodes != null ? this.asNodes.length : 0;
    }

    @Override
    public IASNode[] getASNodes() {
        return this.asNodes;
    }

    @Override
    public IASScope getScope() {
        return this.scope;
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).getAllImports(imports);
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> imports) {
        ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).getAllImportNodes(imports);
    }

    @Override
    public IParameterDefinition getEventParameterDefinition() {
        ParameterDefinition result = this.scope.getEventParameterDefinition();
        assert (result != null) : "Even parameter definition should be built before it is accessed";
        return result;
    }

    @Override
    public boolean needsPublicHandler() {
        return ((IMXMLClassReferenceNode)this.getParent()).needsDescriptor();
    }
}

