/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.MultiMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestCodec {
    private static final Logger LOG = LoggerFactory.getLogger(RestCodec.class);

    private RestCodec() {
    }

    public static void argsToRest(Object[] args, RestOperationMeta restOperation, RestClientRequest clientRequest) throws Exception {
        int paramSize = restOperation.getParamList().size();
        if (paramSize == 0) {
            return;
        }
        if (paramSize != args.length) {
            throw new Exception("wrong number of arguments");
        }
        for (int idx = 0; idx < paramSize; ++idx) {
            RestParam param = restOperation.getParamList().get(idx);
            param.getParamProcessor().setValue(clientRequest, args[idx]);
        }
    }

    public static Object[] restToArgs(HttpServletRequest request, RestOperationMeta restOperation) throws InvocationException {
        List<RestParam> paramList = restOperation.getParamList();
        Object[] paramValues = new Object[paramList.size()];
        for (int idx = 0; idx < paramList.size(); ++idx) {
            RestParam param = paramList.get(idx);
            try {
                paramValues[idx] = param.getParamProcessor().getValue(request);
                continue;
            }
            catch (Exception e) {
                String message = String.format("Parameter is not valid for operation [%s]. Parameter is [%s]. Processor is [%s].", restOperation.getOperationMeta().getMicroserviceQualifiedName(), param.getParamName(), param.getParamProcessor().getProcessorType());
                if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.codec.printErrorMessage", false).get()) {
                    LOG.error(message, (Throwable)e);
                    throw new InvocationException(Response.Status.BAD_REQUEST.getStatusCode(), "", (Object)message, (Throwable)e);
                }
                LOG.error("{} Add {}=true to print the details.", (Object)message, (Object)"servicecomb.codec.printErrorMessage");
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, message);
            }
        }
        return paramValues;
    }

    public static void copyHeadersToHttpResponse(MultiMap headers, HttpServletResponseEx responseEx) {
        if (headers == null) {
            return;
        }
        headers.remove("Content-Length");
        headers.remove("Transfer-Encoding");
        for (Map.Entry entry : headers.entries()) {
            responseEx.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

