/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ManagedResource(description="Can be used to reset the reverse proxy routes")
public class RoutesMvcEndpoint
extends EndpointMvcAdapter
implements ApplicationEventPublisherAware {
    static final String FORMAT_DETAILS = "details";
    private final RoutesEndpoint endpoint;
    private RouteLocator routes;
    private ApplicationEventPublisher publisher;

    public RoutesMvcEndpoint(RoutesEndpoint endpoint, RouteLocator routes) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.routes = routes;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    @ManagedOperation
    public Object reset() {
        this.publisher.publishEvent((ApplicationEvent)new RoutesRefreshedEvent(this.routes));
        return super.invoke();
    }

    @GetMapping(params={"format"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public Object invokeRouteDetails(@RequestParam String format) {
        if (FORMAT_DETAILS.equalsIgnoreCase(format)) {
            return this.endpoint.invokeRouteDetails();
        }
        return super.invoke();
    }
}

