/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.parameter;

import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.servicecomb.swagger.generator.core.DefaultParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringmvcDefaultObjectParameterProcessor
implements DefaultParameterProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringmvcDefaultObjectParameterProcessor.class);

    public void process(OperationGenerator operationGenerator, int paramIndex) {
        Model paramModel = this.getParamModel(operationGenerator, paramIndex);
        if (null == paramModel) {
            throw new Error(String.format("cannot find param, provider method is [%s], paramIndex = [%d]. Please check your parameter definition.", operationGenerator.getProviderMethod().getName(), paramIndex));
        }
        LinkedHashMap<String, AbstractSerializableParameter<?>> resultParamMap = this.getFlattenParams(paramModel);
        this.addProviderParams(operationGenerator, resultParamMap);
    }

    private void addProviderParams(OperationGenerator operationGenerator, LinkedHashMap<String, AbstractSerializableParameter<?>> resultParamMap) {
        resultParamMap.forEach((paramName, param) -> operationGenerator.addProviderParameter((Parameter)param));
    }

    private Model getParamModel(OperationGenerator operationGenerator, int paramIndex) {
        Type paramType = ParamUtils.getGenericParameterType((Class)operationGenerator.getCls(), (Method)operationGenerator.getProviderMethod(), (int)paramIndex);
        Property property = ModelConverters.getInstance().readAsProperty(paramType);
        if (!RefProperty.class.isInstance(property)) {
            LOGGER.error("Unsupported property type: [{}], paramIndex is [{}]", (Object)property.getClass().getName(), (Object)paramIndex);
            return null;
        }
        Map models = ModelConverters.getInstance().readAll(paramType);
        RefProperty refProperty = (RefProperty)property;
        String refTypeName = refProperty.getSimpleRef();
        Model paramRoot = null;
        for (Map.Entry entry : models.entrySet()) {
            if (!refTypeName.equals(entry.getKey())) continue;
            paramRoot = (Model)entry.getValue();
            break;
        }
        return paramRoot;
    }

    private LinkedHashMap<String, AbstractSerializableParameter<?>> getFlattenParams(Model paramModel) {
        LinkedHashMap flattenParamMap = new LinkedHashMap();
        for (Map.Entry<String, Property> entry : paramModel.getProperties().entrySet()) {
            if (ParamUtils.isComplexProperty((Property)((Property)entry.getValue()))) {
                throw new Error("A nesting complex field is found in the query object and this is not supported, field name  = [" + entry.getKey() + "]. Please remove this field or tag @JsonIgnore on it.");
            }
            AbstractSerializableParameter<?> newParameter = this.createSimpleParam(entry);
            flattenParamMap.put(entry.getKey(), newParameter);
        }
        return flattenParamMap;
    }

    private AbstractSerializableParameter<?> createSimpleParam(Map.Entry<String, Property> propertyEntry) {
        QueryParameter newParameter = new QueryParameter();
        newParameter.setName(propertyEntry.getKey());
        newParameter.setProperty(propertyEntry.getValue());
        return newParameter;
    }
}

