/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import jakarta.servlet.MultipartConfigElement;
import org.apache.servicecomb.common.rest.RestConst;
import org.springframework.core.env.Environment;

public class UploadConfig {
    private final Environment environment;

    public UploadConfig(Environment environment) {
        this.environment = environment;
    }

    public String getLocation() {
        return this.environment.getProperty("servicecomb.uploads.directory", RestConst.UPLOAD_DEFAULT_DIR);
    }

    public long getMaxFileSize() {
        return (Long)this.environment.getProperty("servicecomb.uploads.maxFileSize", Long.TYPE, (Object)-1L);
    }

    public long getMaxSize() {
        return (Long)this.environment.getProperty("servicecomb.uploads.maxSize", Long.TYPE, (Object)-1L);
    }

    public int getFileSizeThreshold() {
        return (Integer)this.environment.getProperty("servicecomb.uploads.fileSizeThreshold", Integer.TYPE, (Object)0);
    }

    public MultipartConfigElement toMultipartConfigElement() {
        return new MultipartConfigElement(this.getLocation(), this.getMaxFileSize(), this.getMaxSize(), this.getFileSizeThreshold());
    }
}

