/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.parameters.Parameter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BodyProcessorCreator
implements ParamValueProcessorCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyProcessorCreator.class);
    public static final String PARAMTYPE = "body";
    private static final JavaType OBJECT_TYPE = SimpleType.constructUnsafe(Object.class);
    private static boolean decodeAsObject = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.decodeAsObject", false).get();

    public BodyProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = TypeFactory.defaultInstance().constructType(genericParamType);
        boolean rawJson = ClassUtils.isRawJsonType((Parameter)parameter);
        if (genericParamType.getTypeName().equals(String.class.getTypeName()) && rawJson) {
            return new RawJsonBodyProcessor(targetType, parameter.getRequired());
        }
        return new BodyProcessor(targetType, parameter.getRequired());
    }

    public static class RawJsonBodyProcessor
    extends BodyProcessor {
        public RawJsonBodyProcessor(JavaType targetType, boolean isRequired) {
            super(targetType, isRequired);
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            clientRequest.putHeader("Content-Type", "application/json");
            clientRequest.write(Buffer.buffer((String)((String)arg)));
        }
    }

    public static class BodyProcessor
    implements ParamValueProcessor {
        protected JavaType targetType;
        protected boolean isRequired;

        public BodyProcessor(JavaType targetType, boolean isRequired) {
            this.targetType = targetType;
            this.isRequired = isRequired;
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            String contentType = request.getContentType();
            String string = contentType = contentType == null ? "" : contentType.toLowerCase(Locale.US);
            if (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded")) {
                return this.convertValue(request.getParameterMap(), this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            if (!contentType.isEmpty() && !contentType.startsWith("application/json")) {
                return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
            try {
                if (decodeAsObject) {
                    return RestObjectMapperFactory.getRestObjectMapper().readValue((InputStream)inputStream, OBJECT_TYPE);
                }
                return RestObjectMapperFactory.getRestObjectMapper().readValue((InputStream)inputStream, this.targetType);
            }
            catch (MismatchedInputException e) {
                if (!this.isRequired && e.getMessage().contains("No content to map due to end-of-input")) {
                    LOGGER.info("Empty content and required is false, taken as null");
                    return null;
                }
                throw e;
            }
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            this.ensureContentType(clientRequest);
            if (arg != null) {
                Buffer buffer = this.createBodyBuffer(clientRequest.getHeaders().get("Content-Type"), arg);
                clientRequest.write(buffer);
            }
        }

        private Buffer createBodyBuffer(String contentType, Object arg) throws IOException {
            if ("text/plain".equals(contentType)) {
                if (!String.class.isInstance(arg)) {
                    throw new IllegalArgumentException("Content-Type is text/plain while arg type is not String");
                }
                return new BufferImpl().appendBytes(((String)arg).getBytes());
            }
            try (BufferOutputStream output = new BufferOutputStream();){
                RestObjectMapperFactory.getConsumerWriterMapper().writeValue((OutputStream)output, arg);
                Buffer buffer = output.getBuffer();
                return buffer;
            }
        }

        private void ensureContentType(RestClientRequest clientRequest) {
            if (null == clientRequest.getHeaders() || StringUtils.isEmpty((Object)clientRequest.getHeaders().get("Content-Type"))) {
                clientRequest.putHeader("Content-Type", "application/json");
            }
        }

        @Override
        public String getParameterPath() {
            return "";
        }

        @Override
        public String getProcessorType() {
            return BodyProcessorCreator.PARAMTYPE;
        }
    }
}

