/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class FormProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "formData";

    public FormProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = TypeFactory.defaultInstance().constructType(genericParamType);
        if (this.isPart(parameter)) {
            return new PartProcessor(parameter.getName(), targetType, ((FormParameter)parameter).getDefaultValue(), parameter.getRequired());
        }
        return new FormProcessor(parameter.getName(), targetType, ((FormParameter)parameter).getDefaultValue(), parameter.getRequired());
    }

    private boolean isPart(Parameter parameter) {
        FormParameter formParameter = (FormParameter)parameter;
        if ("array".equals(formParameter.getType())) {
            Property items = formParameter.getItems();
            return new FileProperty().getType().equals(items.getType());
        }
        return new FileProperty().getType().equals(formParameter.getType());
    }

    public static class PartProcessor
    extends AbstractParamProcessor {
        PartProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            JavaType contentType;
            if (List.class.isAssignableFrom(this.targetType.getRawClass()) && (contentType = this.targetType.getContentType()) != null && contentType.getRawClass().equals(Part.class)) {
                return request.getParts().stream().filter(part -> part.getName().equals(this.paramPath)).collect(Collectors.toList());
            }
            return request.getPart(this.paramPath);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            clientRequest.attach(this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return FormProcessorCreator.PARAMTYPE;
        }
    }

    public static class FormProcessor
    extends AbstractParamProcessor {
        public FormProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            Map forms = (Map)request.getAttribute("servicecomb-forms");
            if (forms != null && !forms.isEmpty()) {
                return this.convertValue(forms.get(this.paramPath), this.targetType);
            }
            if (this.targetType.isContainerType()) {
                return this.convertValue(request.getParameterValues(this.paramPath), this.targetType);
            }
            Object value = request.getParameter(this.paramPath);
            if (value == null) {
                value = this.checkRequiredAndDefaultValue();
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) {
            clientRequest.addForm(this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return FormProcessorCreator.PARAMTYPE;
        }
    }
}

