/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaJAXRSServerCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class JavaJAXRSSpecServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String RETURN_RESPONSE = "returnResponse";
    public static final String GENERATE_POM = "generatePom";
    private boolean interfaceOnly = false;
    private boolean returnResponse = false;
    private boolean generatePom = true;

    public JavaJAXRSSpecServerCodegen() {
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-server";
        this.outputFolder = "generated-code/JavaJaxRS-Spec";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.additionalProperties.put("title", this.title);
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "spec";
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!"library".equals(((CliOption)this.cliOptions.get(i)).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "JAXRS");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
        this.cliOptions.add(CliOption.newBoolean(GENERATE_POM, "Whether to generate pom.xml if the file does not already exist.").defaultValue(String.valueOf(this.generatePom)));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.").defaultValue(String.valueOf(this.interfaceOnly)));
        this.cliOptions.add(CliOption.newBoolean(RETURN_RESPONSE, "Whether generate API interface should return javax.ws.rs.core.Response instead of a deserialized entity. Only useful if interfaceOnly is true.").defaultValue(String.valueOf(this.returnResponse)));
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(GENERATE_POM)) {
            this.generatePom = Boolean.valueOf(this.additionalProperties.get(GENERATE_POM).toString());
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.interfaceOnly = Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY).toString());
            if (!this.interfaceOnly) {
                this.additionalProperties.remove(INTERFACE_ONLY);
            }
        }
        if (this.additionalProperties.containsKey(RETURN_RESPONSE)) {
            this.returnResponse = Boolean.valueOf(this.additionalProperties.get(RETURN_RESPONSE).toString());
            if (!this.returnResponse) {
                this.additionalProperties.remove(RETURN_RESPONSE);
            }
        }
        if (this.interfaceOnly) {
            this.artifactId = "swagger-jaxrs-client";
        }
        super.processOpts();
        this.supportingFiles.clear();
        if (this.generatePom) {
            this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        }
        if (!this.interfaceOnly) {
            this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        }
    }

    @Override
    public String getName() {
        return "jaxrs-spec";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
        model.imports.remove("JsonValue");
        model.imports.remove("JsonProperty");
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        try {
            String swaggerJson = Json.pretty((Object)swagger);
            FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + "swagger.json"), (String)swaggerJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        super.preprocessSwagger(swagger);
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server according to JAXRS 2.0 specification.";
    }
}

