/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private EncodingPatternConverter(List<PatternFormatter> formatters) {
        super("encode", "encode");
        this.formatters = formatters;
    }

    public static EncodingPatternConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on escape. Expected 1, received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new EncodingPatternConverter(formatters);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, buf);
        }
        block11: for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            switch (c) {
                case '\r': {
                    toAppendTo.append("\\r");
                    continue block11;
                }
                case '\n': {
                    toAppendTo.append("\\n");
                    continue block11;
                }
                case '&': {
                    toAppendTo.append("&amp;");
                    continue block11;
                }
                case '<': {
                    toAppendTo.append("&lt;");
                    continue block11;
                }
                case '>': {
                    toAppendTo.append("&gt;");
                    continue block11;
                }
                case '\"': {
                    toAppendTo.append("&quot;");
                    continue block11;
                }
                case '\'': {
                    toAppendTo.append("&apos;");
                    continue block11;
                }
                case '/': {
                    toAppendTo.append("&#x2F;");
                    continue block11;
                }
                default: {
                    toAppendTo.append(c);
                }
            }
        }
    }
}

