/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.Set;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.ValueReference;

public interface FeatureExpression<R, V>
extends Expression<R, V> {
    default public Set<FunctionProperty> properties() {
        return Node.transitiveProperties(this.getParameters());
    }

    default public Class<?> getValueClass() {
        return Object.class;
    }

    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder var1);

    public static <R> FeatureExpression<? super R, ?> castOrCopy(Expression<R, ?> candidate) {
        Expression copy;
        if (candidate instanceof FeatureExpression) {
            return (FeatureExpression)candidate;
        }
        if (candidate instanceof Literal) {
            copy = Optimization.literal(((Literal)candidate).getValue());
        } else if (candidate instanceof ValueReference) {
            String xpath = ((ValueReference)candidate).getXPath();
            copy = DefaultFilterFactory.forResources(candidate.getResourceClass()).map(factory -> factory.property(xpath)).orElse(null);
        } else {
            return null;
        }
        return (FeatureExpression)copy;
    }
}

