/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public abstract class SelectionUtils {
    public static List<IServer> getServersLinkedToProject(IStructuredSelection sel, IProgressMonitor monitor) {
        if (sel.isEmpty()) {
            return Collections.emptyList();
        }
        Object first = sel.iterator().next();
        if (!(first instanceof IProject)) {
            return Collections.emptyList();
        }
        IProject project = (IProject)first;
        return SelectionUtils.getServersLinkedToProject(project, monitor);
    }

    public static List<IServer> getServersLinkedToProject(IProject project, IProgressMonitor monitor) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<IServer> servers = new ArrayList<IServer>();
        IModule[] modules = ServerUtil.getModules((IProject)project);
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IModule[] iModuleArray = modules;
            int n3 = modules.length;
            int n4 = 0;
            while (n4 < n3) {
                IModule module = iModuleArray[n4];
                if (ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)monitor)) {
                    servers.add(server);
                }
                ++n4;
            }
            ++n2;
        }
        return servers;
    }

    public static <T> T getFirst(ISelection selection, Class<T> type) {
        Object selected;
        if (selection instanceof IStructuredSelection && type.isInstance(selected = ((IStructuredSelection)selection).getFirstElement())) {
            return (T)selected;
        }
        return null;
    }

    public static ISelection getSelectionFromEvaluationContext(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            return null;
        }
        IEvaluationContext ctx = (IEvaluationContext)evaluationContext;
        Object selection = ctx.getVariable("selection");
        if (!(selection instanceof ISelection)) {
            return null;
        }
        return (ISelection)selection;
    }

    private SelectionUtils() {
    }
}

