/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.providers;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormValueProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormValueProvider.class})
public class SuffixResourceFormValueProvider
implements FormValueProvider {
    private static final Logger log = LoggerFactory.getLogger(SuffixResourceFormValueProvider.class);

    @Override
    public void loadValues(SlingHttpServletRequest request, Resource providerResource, Map<String, Object> formData) {
        log.trace("loadValues");
        Resource suffixResource = request.getRequestPathInfo().getSuffixResource();
        ValueMap providerProperties = providerResource.getValueMap();
        StringSubstitutor sub = new StringSubstitutor(formData);
        String basePath = sub.replace((String)providerProperties.get("basePath", String.class));
        String[] allowedProperties = (String[])providerProperties.get("allowedProperties", String[].class);
        if (suffixResource != null && suffixResource.getPath().startsWith(basePath)) {
            ValueMap suffixProperties = suffixResource.getValueMap();
            if (allowedProperties != null && allowedProperties.length > 0) {
                Arrays.stream(allowedProperties).filter(arg_0 -> suffixProperties.containsKey(arg_0)).forEach(p -> formData.put((String)p, suffixProperties.get(p)));
            } else {
                formData.putAll((Map<String, Object>)suffixProperties);
            }
            formData.put("suffixResource", suffixResource.getPath());
        }
    }

    @Override
    public boolean handles(Resource valueProviderResource) {
        return "reference/components/forms/providers/suffixresource".equals(valueProviderResource.getResourceType());
    }
}

