/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.apache.sling.crankstart.api.CrankstartException;
import org.apache.sling.crankstart.core.CrankstartParserImpl;
import org.apache.sling.crankstart.core.commands.Configure;
import org.apache.sling.crankstart.core.commands.Defaults;
import org.apache.sling.crankstart.core.commands.Exit;
import org.apache.sling.crankstart.core.commands.InstallBundle;
import org.apache.sling.crankstart.core.commands.Log;
import org.apache.sling.crankstart.core.commands.NullCommand;
import org.apache.sling.crankstart.core.commands.SetOsgiFrameworkProperty;
import org.apache.sling.crankstart.core.commands.StartBundles;
import org.apache.sling.crankstart.core.commands.StartFramework;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrankstartFileProcessor
implements Callable<Object> {
    private final CrankstartContext crankstartContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<CrankstartCommand> builtinCommands = new ArrayList<CrankstartCommand>();
    private List<CrankstartCommand> extensionCommands = new ArrayList<CrankstartCommand>();

    public CrankstartFileProcessor() {
        this(new CrankstartContext());
    }

    public CrankstartFileProcessor(CrankstartContext ctx) {
        this.crankstartContext = ctx;
        this.builtinCommands.add(new InstallBundle());
        this.builtinCommands.add(new Log());
        this.builtinCommands.add(new SetOsgiFrameworkProperty());
        this.builtinCommands.add(new StartBundles());
        this.builtinCommands.add(new StartFramework());
        this.builtinCommands.add(new Configure());
        this.builtinCommands.add(new Defaults());
        this.builtinCommands.add(new Exit());
        this.builtinCommands.add(new NullCommand("classpath", "set the classpath used by the Crankstart launcher"));
        this.log.info("{} ready, built-in commands: {}", (Object)this.getClass().getSimpleName(), (Object)this.getDescriptions(this.builtinCommands));
    }

    @Override
    public Object call() throws Exception {
        String inputFilename = System.getProperty("crankstart.input.filename");
        if (inputFilename == null) {
            throw new CrankstartException("Missing system property crankstart.input.filename");
        }
        this.process(new FileReader(new File(inputFilename)));
        if (this.crankstartContext.getAttribute("stop.osgi.framework") != null) {
            this.log.info("Stopping OSGi framework due to {} attribute (state={})", (Object)"stop.osgi.framework", (Object)this.crankstartContext.getOsgiFramework().getState());
            this.crankstartContext.getOsgiFramework().stop();
            System.exit(0);
        } else {
            this.waitForExit();
        }
        return null;
    }

    private int execute(CrankstartCommandLine cmdLine, Collection<CrankstartCommand> candidateCommands) throws Exception {
        int executed = 0;
        for (CrankstartCommand cmd : candidateCommands) {
            if (!cmd.appliesTo(cmdLine)) continue;
            cmd.execute(this.crankstartContext, cmdLine);
            ++executed;
        }
        return executed;
    }

    public void process(Reader input) throws Exception {
        CrankstartParserImpl parser = new CrankstartParserImpl(){

            @Override
            protected String getVariable(String name) {
                String result = System.getProperty(name);
                if (result == null) {
                    result = (String)CrankstartFileProcessor.this.crankstartContext.getDefaults().get(name);
                }
                if (result == null) {
                    result = super.getVariable(name);
                }
                if (result != null) {
                    result = result.trim();
                }
                return result;
            }
        };
        Iterator<CrankstartCommandLine> it = parser.parse(input);
        while (it.hasNext()) {
            CrankstartCommandLine cmdLine = it.next();
            if (this.execute(cmdLine, this.builtinCommands) == 0 && this.execute(cmdLine, this.extensionCommands) == 0) {
                this.reloadExtensionCommands();
                if (this.execute(cmdLine, this.extensionCommands) == 0) {
                    throw new CrankstartException("Invalid command '" + cmdLine.getVerb() + "', built-in commands:" + this.getDescriptions(this.builtinCommands) + ", extension commands: " + this.getDescriptions(this.extensionCommands));
                }
            }
            if (this.crankstartContext.getAttribute("crankstart.stop.processing") == null) continue;
            this.log.info("{} attribute is set, ignoring the remaining crankstart commands", (Object)"crankstart.stop.processing");
            break;
        }
    }

    private synchronized void reloadExtensionCommands() throws InvalidSyntaxException {
        if (this.crankstartContext.getOsgiFramework() == null) {
            return;
        }
        this.extensionCommands.clear();
        BundleContext bc = this.crankstartContext.getOsgiFramework().getBundleContext();
        ServiceReference[] refs = bc.getServiceReferences(CrankstartCommand.class.getName(), null);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                this.extensionCommands.add((CrankstartCommand)bc.getService(ref));
            }
        }
        this.log.info("Reloaded extension commands: {}", (Object)this.getDescriptions(this.extensionCommands));
    }

    public void waitForExit() throws InterruptedException {
        if (this.crankstartContext.getOsgiFramework() == null) {
            throw new IllegalStateException("OSGi framework not started");
        }
        this.log.info("Waiting for OSGi framework to exit...");
        this.crankstartContext.getOsgiFramework().waitForStop(0L);
        this.log.info("OSGi framework exited");
    }

    private String getDescriptions(Collection<CrankstartCommand> commands) throws CrankstartException {
        StringBuilder sb = new StringBuilder();
        for (CrankstartCommand cmd : commands) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cmd.getDescription());
        }
        if (sb.length() == 0) {
            sb.append("<none>");
        }
        return sb.toString();
    }
}

