/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopologyView
extends BaseTopologyView {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Set<InstanceDescription> instances = new HashSet<InstanceDescription>();
    private String localClusterSyncTokenId;

    public DefaultTopologyView() {
    }

    public DefaultTopologyView(Collection<InstanceDescription> instances) {
        if (instances != null) {
            this.instances.addAll(instances);
        }
    }

    public TopologyEvent.Type compareTopology(DefaultTopologyView other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (this.localClusterSyncTokenId == null && other.localClusterSyncTokenId != null || other.localClusterSyncTokenId == null && this.localClusterSyncTokenId != null || this.localClusterSyncTokenId != null && !this.localClusterSyncTokenId.equals(other.localClusterSyncTokenId)) {
            this.logger.debug("compareTopology: different localClusterSyncTokenId");
            return TopologyEvent.Type.TOPOLOGY_CHANGED;
        }
        if (this.instances.size() != other.instances.size()) {
            this.logger.debug("compareTopology: different number of instances");
            return TopologyEvent.Type.TOPOLOGY_CHANGED;
        }
        boolean propertiesChanged = false;
        for (InstanceDescription instance : this.instances) {
            Iterator<InstanceDescription> it2 = other.instances.iterator();
            InstanceDescription matchingInstance = null;
            while (it2.hasNext()) {
                InstanceDescription otherInstance = it2.next();
                if (!instance.getSlingId().equals(otherInstance.getSlingId())) continue;
                matchingInstance = otherInstance;
                break;
            }
            if (matchingInstance == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("compareTopology: no matching instance found for {}", (Object)instance);
                }
                return TopologyEvent.Type.TOPOLOGY_CHANGED;
            }
            if (!instance.getClusterView().getId().equals(matchingInstance.getClusterView().getId())) {
                this.logger.debug("compareTopology: cluster view id does not match");
                return TopologyEvent.Type.TOPOLOGY_CHANGED;
            }
            if (!instance.isLeader() == matchingInstance.isLeader()) {
                this.logger.debug("compareTopology: leaders differ");
                return TopologyEvent.Type.TOPOLOGY_CHANGED;
            }
            if (instance.getProperties().equals(matchingInstance.getProperties())) continue;
            propertiesChanged = true;
        }
        if (propertiesChanged) {
            return TopologyEvent.Type.PROPERTIES_CHANGED;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefaultTopologyView)) {
            return false;
        }
        DefaultTopologyView other = (DefaultTopologyView)((Object)obj);
        if (this.isCurrent() != other.isCurrent()) {
            return false;
        }
        TopologyEvent.Type diff = this.compareTopology(other);
        return diff == null;
    }

    public int hashCode() {
        int code = 0;
        for (InstanceDescription instance : this.instances) {
            code += instance.hashCode();
        }
        return code;
    }

    public InstanceDescription getLocalInstance() {
        for (InstanceDescription instance : this.instances) {
            if (!instance.isLocal()) continue;
            return instance;
        }
        return null;
    }

    public Set<InstanceDescription> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }

    public void setLocalClusterView(LocalClusterView localClusterView) {
        if (localClusterView == null) {
            throw new IllegalArgumentException("localClusterView must not be null");
        }
        List instances = localClusterView.getInstances();
        this.addInstances(instances);
        this.localClusterSyncTokenId = localClusterView.getLocalClusterSyncTokenId();
    }

    public void addInstances(Collection<InstanceDescription> instances) {
        if (instances == null) {
            return;
        }
        block0: for (InstanceDescription instanceDescription : instances) {
            for (InstanceDescription existingInstance : this.instances) {
                if (!existingInstance.getSlingId().equals(instanceDescription.getSlingId())) continue;
                this.logger.info("addInstance: cannot add same instance twice: " + instanceDescription);
                continue block0;
            }
            this.instances.add(instanceDescription);
        }
    }

    public Set<InstanceDescription> findInstances(InstanceFilter picker) {
        if (picker == null) {
            throw new IllegalArgumentException("picker must not be null");
        }
        HashSet<InstanceDescription> result = new HashSet<InstanceDescription>();
        for (InstanceDescription instance : this.instances) {
            if (!picker.accept(instance)) continue;
            result.add(instance);
        }
        return result;
    }

    public Set<ClusterView> getClusterViews() {
        HashSet<ClusterView> result = new HashSet<ClusterView>();
        for (InstanceDescription instance : this.instances) {
            ClusterView cluster = instance.getClusterView();
            if (cluster == null) continue;
            result.add(cluster);
        }
        return new HashSet<ClusterView>(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            boolean firstCluster = true;
            for (ClusterView clusterView : this.getClusterViews()) {
                if (!firstCluster) {
                    sb.append(", ");
                }
                firstCluster = false;
                sb.append("[clusterId=" + clusterView.getId() + ", instances=");
                boolean firstInstance = true;
                for (InstanceDescription id : clusterView.getInstances()) {
                    if (!firstInstance) {
                        sb.append(", ");
                    }
                    firstInstance = false;
                    sb.append("[id=" + id.getSlingId() + ", isLeader=" + id.isLeader() + ", isLocal=" + id.isLocal() + "]");
                }
                sb.append("]");
            }
        }
        catch (Exception e) {
            sb = new StringBuilder(this.instances.toString());
        }
        return "DefaultTopologyView[current=" + this.isCurrent() + ", num=" + this.instances.size() + ", instances=" + sb + "]";
    }

    public String getLocalClusterSyncTokenId() {
        if (this.localClusterSyncTokenId == null) {
            throw new IllegalStateException("no syncToken set");
        }
        return this.localClusterSyncTokenId;
    }
}

