/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.ScheduledDistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTrigger.class}, property={"webconsole.configurationFactory.nameHint=Trigger name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class ScheduledDistributionTriggerFactory
implements DistributionTrigger {
    private ScheduledDistributionTrigger trigger;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Scheduler scheduler;

    @Activate
    public void activate(BundleContext bundleContext, Config conf) {
        String action = conf.action();
        if (action == null || action.isEmpty()) {
            action = DistributionRequestType.PULL.name();
        }
        String path = conf.path();
        int interval = conf.seconds();
        String serviceName = SettingsUtils.removeEmptyEntry(conf.serviceName());
        this.trigger = new ScheduledDistributionTrigger(action, path, interval, serviceName, this.scheduler, this.resolverFactory);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Trigger - Scheduled Triggers Factory", description="Triggers a distribution request of the given type (action) for the given path (path) at a periodical time interval (seconds).")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the trigger.")
        public String name();

        @AttributeDefinition(name="Distribution Type", description="The type of the distribution request produced by this trigger in ('ADD', 'DELETE', 'PULL', 'TEST'). Default 'PULL'.")
        public String action();

        @AttributeDefinition(name="Name", description="The path to be distributed periodically.")
        public String path();

        @AttributeDefinition(name="Interval in Seconds", description="The number of seconds between distribution requests. Default 30 seconds.")
        public int seconds() default 30;

        @AttributeDefinition(name="Service Name", description="The name of the service used to trigger the distribution requests.")
        public String serviceName();
    }
}

