/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type.helpers;

import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;

final class SyntheticNavigatableResource
extends AbstractResource {
    private final String path;
    private final ResourceResolver resolver;
    private ResourceMetadata metadata;
    private static final String RESOURCE_TYPE = "wcm-io/handler/link/synthetic/resource/navigatable";

    private SyntheticNavigatableResource(String path, ResourceResolver resolver) {
        this.path = path;
        this.resolver = resolver;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    public String getResourceSuperType() {
        return null;
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        if (this.metadata == null) {
            this.metadata = new ResourceMetadata();
            this.metadata.setResolutionPath(this.path);
        }
        return this.metadata;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Resource getParent() {
        if (this.path == null) {
            return null;
        }
        String parentPath = ResourceUtil.getParent((String)this.path);
        if (parentPath == null) {
            return null;
        }
        return SyntheticNavigatableResource.get(parentPath, this.resolver);
    }

    @NotNull
    static Resource get(String path, ResourceResolver resolver) {
        Resource resource = resolver.getResource(path);
        if (resource != null) {
            return resource;
        }
        return new SyntheticNavigatableResource(path, resolver);
    }
}

