/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class JcrBinary {
    private JcrBinary() {
    }

    public static boolean isNtFile(Resource resource) {
        return JcrBinary.isNt(resource, "nt:file");
    }

    public static boolean isNtResource(Resource resource) {
        return JcrBinary.isNt(resource, "nt:resource");
    }

    public static boolean isNtFileOrResource(Resource resource) {
        return JcrBinary.isNtFile(resource) || JcrBinary.isNtResource(resource);
    }

    public static String getMimeType(Resource resource) {
        if (JcrBinary.isNtResource(resource)) {
            return (String)resource.getValueMap().get("jcr:mimeType", String.class);
        }
        if (JcrBinary.isNtFile(resource)) {
            return JcrBinary.getMimeType(resource.getChild("jcr:content"));
        }
        return null;
    }

    private static boolean isNt(Resource resource, String nodeTypeName) {
        if (resource != null) {
            return StringUtils.equals((CharSequence)resource.getResourceType(), (CharSequence)nodeTypeName);
        }
        return false;
    }
}

