/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntityAddition;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescriptionAddition;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescriptionAddition;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;

public class ConfigurationApi
extends AttributeableEntity {
    public static final String EXTENSION_NAME = "configuration-api";
    private final Map<String, ConfigurationDescription> configurations = new LinkedHashMap<String, ConfigurationDescription>();
    private final Map<String, FactoryConfigurationDescription> factories = new LinkedHashMap<String, FactoryConfigurationDescription>();
    private final Map<String, ConfigurationDescriptionAddition> configurationAdditions = new LinkedHashMap<String, ConfigurationDescriptionAddition>();
    private final Map<String, FactoryConfigurationDescriptionAddition> factoryAdditions = new LinkedHashMap<String, FactoryConfigurationDescriptionAddition>();
    private final Map<String, FrameworkPropertyDescription> frameworkProperties = new LinkedHashMap<String, FrameworkPropertyDescription>();
    private final Set<String> internalFrameworkProperties = new TreeSet<String>();
    private Region region;
    private final Map<ArtifactId, Region> regionCache = new LinkedHashMap<ArtifactId, Region>();
    private Mode mode;

    public static ConfigurationApi getConfigurationApi(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return ConfigurationApi.getConfigurationApi(ext);
    }

    public static ConfigurationApi getConfigurationApi(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        try {
            ConfigurationApi result = new ConfigurationApi();
            result.fromJSONObject(ext.getJSONStructure().asJsonObject());
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage(), ioe);
        }
    }

    public static void setConfigurationApi(Feature feature, ConfigurationApi api) {
        Extension ext = feature.getExtensions().getByName(EXTENSION_NAME);
        if (api == null) {
            if (ext != null) {
                feature.getExtensions().remove((Object)ext);
            }
        } else {
            if (ext == null) {
                ext = new Extension(ExtensionType.JSON, EXTENSION_NAME, ExtensionState.OPTIONAL);
                feature.getExtensions().add((Object)ext);
            }
            try {
                ext.setJSONStructure((JsonStructure)api.toJSONObject());
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    public ConfigurationApi() {
        this.setDefaults();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.setMode(Mode.STRICT);
    }

    @Override
    public void clear() {
        super.clear();
        this.configurations.clear();
        this.factories.clear();
        this.frameworkProperties.clear();
        this.internalFrameworkProperties.clear();
        this.setRegion(null);
        this.getFeatureToRegionCache().clear();
        this.getConfigurationDescriptionAdditions().clear();
        this.getFactoryConfigurationDescriptionAdditions().clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            ConfigurableEntityAddition cfg;
            String modeVal;
            DescribableEntity cfg2;
            JsonValue val;
            String typeVal = this.getString("region");
            if (typeVal != null) {
                this.setRegion(Region.valueOf(typeVal.toUpperCase()));
            }
            if ((val = this.getAttributes().remove("configurations")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg2 = new ConfigurationDescription();
                    ((ConfigurableEntity)cfg2).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getConfigurationDescriptions().put((String)innerEntry.getKey(), (ConfigurationDescription)cfg2);
                }
            }
            if ((val = this.getAttributes().remove("factory-configurations")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg2 = new FactoryConfigurationDescription();
                    ((FactoryConfigurationDescription)cfg2).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getFactoryConfigurationDescriptions().put((String)innerEntry.getKey(), (FactoryConfigurationDescription)cfg2);
                }
            }
            if ((val = this.getAttributes().remove("framework-properties")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg2 = new FrameworkPropertyDescription();
                    ((PropertyDescription)cfg2).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getFrameworkPropertyDescriptions().put((String)innerEntry.getKey(), (FrameworkPropertyDescription)cfg2);
                }
            }
            if ((val = this.getAttributes().remove("internal-configurations")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    cfg2 = new ConfigurationDescription();
                    this.getConfigurationDescriptions().put(this.getString(innerVal), (ConfigurationDescription)cfg2);
                }
            }
            if ((val = this.getAttributes().remove("internal-factory-configurations")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    cfg2 = new FactoryConfigurationDescription();
                    this.getFactoryConfigurationDescriptions().put(this.getString(innerVal), (FactoryConfigurationDescription)cfg2);
                }
            }
            if ((val = this.getAttributes().remove("internal-framework-properties")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalFrameworkProperties().add(this.getString(innerVal));
                }
            }
            if ((val = this.getAttributes().remove("region-cache")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    this.getFeatureToRegionCache().put(ArtifactId.parse((String)((String)innerEntry.getKey())), Region.valueOf(this.getString((JsonValue)innerEntry.getValue()).toUpperCase()));
                }
            }
            if ((modeVal = this.getString("mode")) != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
            if ((val = this.getAttributes().remove("configuration-additions")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg = new ConfigurationDescriptionAddition();
                    cfg.fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getConfigurationDescriptionAdditions().put((String)innerEntry.getKey(), (ConfigurationDescriptionAddition)cfg);
                }
            }
            if ((val = this.getAttributes().remove("factory-configuration-additions")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg = new FactoryConfigurationDescriptionAddition();
                    ((FactoryConfigurationDescriptionAddition)cfg).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getFactoryConfigurationDescriptionAdditions().put((String)innerEntry.getKey(), (FactoryConfigurationDescriptionAddition)cfg);
                }
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public Map<String, ConfigurationDescription> getConfigurationDescriptions() {
        return this.configurations;
    }

    public Map<String, FactoryConfigurationDescription> getFactoryConfigurationDescriptions() {
        return this.factories;
    }

    public Map<String, FrameworkPropertyDescription> getFrameworkPropertyDescriptions() {
        return this.frameworkProperties;
    }

    public boolean isInternalConfiguration(String pid) {
        boolean result = false;
        ConfigurationDescription desc = this.configurations.get(pid);
        if (desc != null) {
            result = desc.getPropertyDescriptions().isEmpty();
        }
        return result;
    }

    public boolean isInternalFactoryConfiguration(String factoryPid, String name) {
        boolean result = false;
        FactoryConfigurationDescription desc = this.factories.get(factoryPid);
        if (desc != null && !(result = desc.getPropertyDescriptions().isEmpty()) && name != null) {
            result = desc.getInternalNames().contains(name);
        }
        return result;
    }

    public Set<String> getInternalFrameworkProperties() {
        return this.internalFrameworkProperties;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region value) {
        this.region = value;
    }

    public Region detectRegion() {
        if (this.getRegion() != null) {
            return this.getRegion();
        }
        return Region.GLOBAL;
    }

    public Map<ArtifactId, Region> getFeatureToRegionCache() {
        return this.regionCache;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value == null ? Mode.STRICT : value;
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder propBuilder;
        JsonObjectBuilder objBuilder = super.createJson();
        if (this.getRegion() != null) {
            objBuilder.add("region", this.getRegion().name());
        }
        if (!this.getConfigurationDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, ConfigurationDescription> entry : this.getConfigurationDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("configurations", propBuilder);
        }
        if (!this.getFactoryConfigurationDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, ConfigurableEntity> entry : this.getFactoryConfigurationDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), ((FactoryConfigurationDescription)entry.getValue()).createJson());
            }
            objBuilder.add("factory-configurations", propBuilder);
        }
        if (!this.getFrameworkPropertyDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getFrameworkPropertyDescriptions().entrySet()) {
                propBuilder.add((String)entry.getKey(), ((FrameworkPropertyDescription)entry.getValue()).createJson());
            }
            objBuilder.add("framework-properties", propBuilder);
        }
        if (!this.getInternalFrameworkProperties().isEmpty()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getInternalFrameworkProperties()) {
                arrayBuilder.add(string);
            }
            objBuilder.add("internal-framework-properties", arrayBuilder);
        }
        if (!this.getFeatureToRegionCache().isEmpty()) {
            JsonObjectBuilder cacheBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getFeatureToRegionCache().entrySet()) {
                cacheBuilder.add(((ArtifactId)entry.getKey()).toMvnId(), ((Region)((Object)entry.getValue())).name());
            }
            objBuilder.add("region-cache", cacheBuilder);
        }
        if (this.getMode() != Mode.STRICT) {
            objBuilder.add("mode", this.getMode().name());
        }
        if (!this.getConfigurationDescriptionAdditions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getConfigurationDescriptionAdditions().entrySet()) {
                propBuilder.add((String)entry.getKey(), ((ConfigurationDescriptionAddition)entry.getValue()).createJson());
            }
            objBuilder.add("configuration-additions", propBuilder);
        }
        if (!this.getFactoryConfigurationDescriptionAdditions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getFactoryConfigurationDescriptionAdditions().entrySet()) {
                propBuilder.add((String)entry.getKey(), ((FactoryConfigurationDescriptionAddition)entry.getValue()).createJson());
            }
            objBuilder.add("factory-configuration-additions", propBuilder);
        }
        return objBuilder;
    }

    public Map<String, ConfigurationDescriptionAddition> getConfigurationDescriptionAdditions() {
        return this.configurationAdditions;
    }

    public Map<String, FactoryConfigurationDescriptionAddition> getFactoryConfigurationDescriptionAdditions() {
        return this.factoryAdditions;
    }
}

