/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LengthSortComparator;
import org.apache.jackrabbit.core.query.lucene.LowerCaseSortComparator;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldComparatorSource;
import org.apache.jackrabbit.core.query.lucene.UpperCaseSortComparator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LengthImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.UpperCaseImpl;
import org.apache.lucene.search.SortField;

public class Ordering {
    private final Name selectorName;
    private final SortField sort;

    private Ordering(Name selectorName, SortField sort) {
        this.selectorName = selectorName;
        this.sort = sort;
    }

    public Name getSelectorName() {
        return this.selectorName;
    }

    public SortField getSortField() {
        return this.sort;
    }

    public static Ordering fromQOM(final OrderingImpl ordering, final SharedFieldComparatorSource scs, final NamespaceMappings nsMappings) throws RepositoryException {
        final Name[] selectorName = new Name[1];
        DefaultTraversingQOMTreeVisitor visitor = new DefaultTraversingQOMTreeVisitor(){

            public Object visit(LengthImpl node, Object data) throws Exception {
                PropertyValueImpl propValue = (PropertyValueImpl)node.getPropertyValue();
                selectorName[0] = propValue.getSelectorQName();
                return new SortField(propValue.getPropertyQName().toString(), new LengthSortComparator(nsMappings), !ordering.isAscending());
            }

            public Object visit(LowerCaseImpl node, Object data) throws Exception {
                SortField sf = (SortField)((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
                selectorName[0] = node.getSelectorQName();
                return new SortField(sf.getField(), new LowerCaseSortComparator(sf.getComparatorSource()), !ordering.isAscending());
            }

            public Object visit(UpperCaseImpl node, Object data) throws Exception {
                SortField sf = (SortField)((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
                selectorName[0] = node.getSelectorQName();
                return new SortField(sf.getField(), new UpperCaseSortComparator(sf.getComparatorSource()), !ordering.isAscending());
            }

            public Object visit(FullTextSearchScoreImpl node, Object data) throws Exception {
                selectorName[0] = node.getSelectorQName();
                return new SortField(null, 0, !ordering.isAscending());
            }

            public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
                selectorName[0] = node.getSelectorQName();
                return new SortField(FieldNames.LOCAL_NAME, 3, !ordering.isAscending());
            }

            public Object visit(NodeNameImpl node, Object data) throws Exception {
                selectorName[0] = node.getSelectorQName();
                return new SortField(FieldNames.LABEL, 3, !ordering.isAscending());
            }

            public Object visit(PropertyValueImpl node, Object data) throws Exception {
                selectorName[0] = node.getSelectorQName();
                return new SortField(node.getPropertyQName().toString(), scs, !ordering.isAscending());
            }

            public Object visit(OrderingImpl node, Object data) throws Exception {
                return ((DynamicOperandImpl)node.getOperand()).accept((QOMTreeVisitor)this, data);
            }
        };
        try {
            SortField field = (SortField)ordering.accept((QOMTreeVisitor)visitor, null);
            return new Ordering(selectorName[0], field);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

