/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.retention;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.retention.RetentionPolicy;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;

public class RetentionPolicyImpl
implements RetentionPolicy {
    private final Name name;
    private final NodeId nodeId;
    private final NameResolver resolver;
    private int hashCode = 0;

    public static RetentionPolicy createRetentionPolicy(String jcrName, Session session) throws RepositoryException {
        Object resolver = session instanceof NameResolver ? (NameResolver)session : new DefaultNamePathResolver(session);
        return new RetentionPolicyImpl(jcrName, null, (NameResolver)resolver);
    }

    RetentionPolicyImpl(String jcrName, NodeId nodeId, NameResolver resolver) throws IllegalNameException, NamespaceException {
        this(resolver.getQName(jcrName), nodeId, resolver);
    }

    private RetentionPolicyImpl(Name name, NodeId nodeId, NameResolver resolver) {
        this.name = name;
        this.nodeId = nodeId;
        this.resolver = resolver;
    }

    NodeId getNodeId() {
        return this.nodeId;
    }

    public String getName() throws RepositoryException {
        return this.resolver.getJCRName(this.name);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int h = 17;
            h = 37 * h + this.name.hashCode();
            this.hashCode = h = 37 * h + this.nodeId.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RetentionPolicyImpl) {
            RetentionPolicyImpl other = (RetentionPolicyImpl)obj;
            return this.name.equals(other.name) && (this.nodeId == null ? other.nodeId == null : this.nodeId.equals(other.nodeId));
        }
        return false;
    }
}

