/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.handler;

import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.CopyMoveContext;
import org.apache.jackrabbit.server.io.CopyMoveHandler;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.DeleteContext;
import org.apache.jackrabbit.server.io.DeleteHandler;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(immediate=true, service={IOHandler.class, PropertyHandler.class, CopyMoveHandler.class, DeleteHandler.class})
@ServiceRanking(value=1000)
@Designate(ocd=Config.class)
public class DefaultHandlerService
implements IOHandler,
PropertyHandler,
CopyMoveHandler,
DeleteHandler {
    private DefaultHandler delegatee;

    @Activate
    @Modified
    private void activate(Config config) {
        String collectionType = config.type_collections();
        String nonCollectionType = config.type_noncollections();
        String contentType = config.type_content();
        this.delegatee = new DefaultHandler(null, collectionType, nonCollectionType, contentType);
    }

    @Deactivate
    private void deactivate() {
        this.delegatee = null;
    }

    @Override
    public IOManager getIOManager() {
        return this.delegatee.getIOManager();
    }

    @Override
    public void setIOManager(IOManager ioManager) {
        this.delegatee.setIOManager(ioManager);
    }

    @Override
    public String getName() {
        return this.delegatee.getName();
    }

    @Override
    public boolean canImport(ImportContext context, boolean isCollection) {
        return this.delegatee.canImport(context, isCollection);
    }

    @Override
    public boolean canImport(ImportContext context, DavResource resource) {
        return this.delegatee.canImport(context, resource);
    }

    @Override
    public boolean importContent(ImportContext context, boolean isCollection) throws IOException {
        return this.delegatee.importContent(context, isCollection);
    }

    @Override
    public boolean importContent(ImportContext context, DavResource resource) throws IOException {
        return this.delegatee.importContent(context, resource);
    }

    @Override
    public boolean canExport(ExportContext context, boolean isCollection) {
        return this.delegatee.canExport(context, isCollection);
    }

    @Override
    public boolean canExport(ExportContext context, DavResource resource) {
        return this.delegatee.canExport(context, resource);
    }

    @Override
    public boolean exportContent(ExportContext context, boolean isCollection) throws IOException {
        return this.delegatee.exportContent(context, isCollection);
    }

    @Override
    public boolean exportContent(ExportContext context, DavResource resource) throws IOException {
        return this.delegatee.exportContent(context, resource);
    }

    @Override
    public boolean canExport(PropertyExportContext context, boolean isCollection) {
        return this.delegatee.canExport(context, isCollection);
    }

    @Override
    public boolean exportProperties(PropertyExportContext exportContext, boolean isCollection) throws RepositoryException {
        return this.delegatee.exportProperties(exportContext, isCollection);
    }

    @Override
    public boolean canImport(PropertyImportContext context, boolean isCollection) {
        return this.delegatee.canImport(context, isCollection);
    }

    @Override
    public Map<? extends PropEntry, ?> importProperties(PropertyImportContext importContext, boolean isCollection) throws RepositoryException {
        return this.delegatee.importProperties(importContext, isCollection);
    }

    @Override
    public boolean canCopy(CopyMoveContext context, DavResource source, DavResource destination) {
        return this.delegatee.canCopy(context, source, destination);
    }

    @Override
    public boolean copy(CopyMoveContext context, DavResource source, DavResource destination) throws DavException {
        return this.delegatee.copy(context, source, destination);
    }

    @Override
    public boolean canMove(CopyMoveContext context, DavResource source, DavResource destination) {
        return this.delegatee.canMove(context, source, destination);
    }

    @Override
    public boolean move(CopyMoveContext context, DavResource source, DavResource destination) throws DavException {
        return this.delegatee.move(context, source, destination);
    }

    @Override
    public boolean delete(DeleteContext deleteContext, DavResource davResource) throws DavException {
        return this.delegatee.delete(deleteContext, davResource);
    }

    @Override
    public boolean canDelete(DeleteContext deleteContext, DavResource davResource) {
        return this.delegatee.canDelete(deleteContext, davResource);
    }

    @ObjectClassDefinition(name="%defaulthandler.name", description="%defaulthandler.description")
    public static @interface Config {
        @AttributeDefinition(name="%type.collections.name", description="%type.collections.description")
        public String type_collections() default "sling:Folder";

        @AttributeDefinition(name="%type.noncollections.name", description="%type.noncollections.description")
        public String type_noncollections() default "nt:file";

        @AttributeDefinition(name="%type.content.name", description="%type.content.description")
        public String type_content() default "nt:resource";
    }
}

