/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.simple.provider;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.apache.sling.nosql.generic.resource.impl.PathUtil;

public class SimpleNoSqlAdapter
implements NoSqlAdapter {
    private final SortedMap<String, Map<String, Object>> store = new TreeMap<String, Map<String, Object>>();

    public boolean validPath(String path) {
        return !StringUtils.contains((CharSequence)path, (CharSequence)"/invalid/") && !StringUtils.endsWith((CharSequence)path, (CharSequence)"/invalid");
    }

    public NoSqlData get(String path) {
        Map properties = (Map)this.store.get(path);
        if (properties != null) {
            return new NoSqlData(path, properties);
        }
        return null;
    }

    public Iterator<NoSqlData> getChildren(String parentPath) {
        Iterator<String> keys = this.store.keySet().iterator();
        final Pattern childKeyPattern = PathUtil.getChildPathPattern((String)parentPath);
        UnmodifiableIterator childKeys = Iterators.filter(keys, (Predicate)new Predicate<String>(){

            public boolean apply(String path) {
                return childKeyPattern.matcher(path).matches();
            }
        });
        return Iterators.transform((Iterator)childKeys, (Function)new Function<String, NoSqlData>(){

            public NoSqlData apply(String path) {
                return SimpleNoSqlAdapter.this.get(path);
            }
        });
    }

    public boolean store(NoSqlData data) {
        boolean exists = this.store.containsKey(data.getPath());
        this.store.put(data.getPath(), new HashMap(data.getProperties()));
        return !exists;
    }

    public boolean deleteRecursive(String path) {
        boolean deletedAnything = false;
        Pattern pathToDeletePattern = PathUtil.getSameOrDescendantPathPattern((String)path);
        Iterator<Map.Entry<String, Map<String, Object>>> entries = this.store.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Map<String, Object>> entry = entries.next();
            if (!pathToDeletePattern.matcher(entry.getKey()).matches()) continue;
            entries.remove();
            deletedAnything = true;
        }
        return deletedAnything;
    }

    public Iterator<NoSqlData> query(String query, String language) {
        if (StringUtils.equals((CharSequence)language, (CharSequence)"simple") && StringUtils.equals((CharSequence)query, (CharSequence)"all")) {
            final Iterator<Map.Entry<String, Map<String, Object>>> entries = this.store.entrySet().iterator();
            return new Iterator<NoSqlData>(){

                @Override
                public boolean hasNext() {
                    return entries.hasNext();
                }

                @Override
                public NoSqlData next() {
                    Map.Entry entry = (Map.Entry)entries.next();
                    return new NoSqlData((String)entry.getKey(), (Map)entry.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.emptyList().iterator();
    }

    public void checkConnection() throws LoginException {
    }

    public void createIndexDefinitions() {
    }
}

