/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.adapter;

import java.util.Iterator;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.slf4j.Logger;

public final class MetricsNoSqlAdapterWrapper
implements NoSqlAdapter {
    private final NoSqlAdapter delegate;
    private final Logger logger;

    public MetricsNoSqlAdapterWrapper(NoSqlAdapter delegate, Logger logger) {
        this.delegate = delegate;
        this.logger = logger;
    }

    @Override
    public boolean validPath(String path) {
        return this.delegate.validPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoSqlData get(String path) {
        NoSqlData noSqlData;
        Metrics metrics = new Metrics();
        try {
            noSqlData = this.delegate.get(path);
        }
        catch (Throwable throwable) {
            metrics.finish("get({})", path);
            throw throwable;
        }
        metrics.finish("get({})", path);
        return noSqlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NoSqlData> getChildren(String parentPath) {
        Iterator<NoSqlData> iterator;
        Metrics metrics = new Metrics();
        try {
            iterator = this.delegate.getChildren(parentPath);
        }
        catch (Throwable throwable) {
            metrics.finish("getChildren({})", parentPath);
            throw throwable;
        }
        metrics.finish("getChildren({})", parentPath);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(NoSqlData data) {
        boolean bl;
        Metrics metrics = new Metrics();
        try {
            bl = this.delegate.store(data);
        }
        catch (Throwable throwable) {
            metrics.finish("store({})", data.getPath());
            throw throwable;
        }
        metrics.finish("store({})", data.getPath());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRecursive(String path) {
        boolean bl;
        Metrics metrics = new Metrics();
        try {
            bl = this.delegate.deleteRecursive(path);
        }
        catch (Throwable throwable) {
            metrics.finish("deleteRecursive({})", path);
            throw throwable;
        }
        metrics.finish("deleteRecursive({})", path);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NoSqlData> query(String query, String language) {
        Iterator<NoSqlData> iterator;
        Metrics metrics = new Metrics();
        try {
            iterator = this.delegate.query(query, language);
        }
        catch (Throwable throwable) {
            metrics.finish("query({})", query);
            throw throwable;
        }
        metrics.finish("query({})", query);
        return iterator;
    }

    @Override
    public void checkConnection() throws LoginException {
        this.delegate.checkConnection();
    }

    @Override
    public void createIndexDefinitions() {
        this.delegate.createIndexDefinitions();
    }

    private class Metrics {
        private long startTime;

        public Metrics() {
            if (MetricsNoSqlAdapterWrapper.this.logger.isDebugEnabled()) {
                this.startTime = System.currentTimeMillis();
            }
        }

        public void finish(String message, Object ... data) {
            if (MetricsNoSqlAdapterWrapper.this.logger.isDebugEnabled()) {
                long duration = System.currentTimeMillis() - this.startTime;
                MetricsNoSqlAdapterWrapper.this.logger.debug(message + " - " + duration + "ms", data);
            }
        }
    }
}

