/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlObserver;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCollector
extends AccessControlObserver
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(EntryCollector.class);
    protected final SessionImpl systemSession;
    protected final NodeId rootID;
    private final PrivilegeRegistry privilegeRegistry;

    protected EntryCollector(SessionImpl systemSession, NodeId rootID) throws RepositoryException {
        this.systemSession = systemSession;
        this.rootID = rootID;
        this.privilegeRegistry = new PrivilegeRegistry(systemSession);
        ObservationManager observationMgr = systemSession.getWorkspace().getObservationManager();
        int events = 19;
        String[] ntNames = new String[]{systemSession.getJCRName(NT_REP_ACCESS_CONTROLLABLE), systemSession.getJCRName(NT_REP_ACL), systemSession.getJCRName(NT_REP_ACE)};
        observationMgr.addEventListener((EventListener)this, events, systemSession.getRootNode().getPath(), true, null, ntNames, true);
    }

    @Override
    protected void close() {
        super.close();
        try {
            this.systemSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while closing CachingEntryCollector", (Throwable)e);
        }
    }

    protected List<AccessControlEntry> collectEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        List<AccessControlEntry> entries;
        LinkedList userAces = new LinkedList();
        LinkedList groupAces = new LinkedList();
        NodeId next = node.getNodeId();
        while (next != null) {
            entries = this.getEntries(next);
            if (!entries.isEmpty() && filter != null) {
                filter.filterEntries(entries, userAces, groupAces);
            }
            next = this.getParentId(next);
        }
        entries = new ArrayList<AccessControlEntry>(userAces.size() + groupAces.size());
        entries.addAll(userAces);
        entries.addAll(groupAces);
        return entries;
    }

    protected List<AccessControlEntry> getEntries(NodeImpl node) throws RepositoryException {
        List<AccessControlEntry> entries;
        if (ACLProvider.isAccessControlled(node)) {
            NodeImpl aclNode = node.getNode(N_POLICY);
            entries = new ACLTemplate(aclNode, this.privilegeRegistry).getEntries();
        } else {
            entries = Collections.emptyList();
        }
        return entries;
    }

    protected List<AccessControlEntry> getEntries(NodeId nodeId) throws RepositoryException {
        NodeImpl node = this.getNodeById(nodeId);
        return this.getEntries(node);
    }

    protected NodeId getParentId(NodeId nodeId) throws RepositoryException {
        NodeId parentId = this.rootID.equals(nodeId) ? null : this.getNodeById(nodeId).getParentId();
        return parentId;
    }

    NodeImpl getNodeById(NodeId nodeId) throws RepositoryException {
        return (NodeImpl)this.systemSession.getItemManager().getItem(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        try {
            String workspaceName = this.systemSession.getWorkspace().getName();
            Session session = this.systemSession.createSession(workspaceName);
            try {
                ACLEventSieve sieve = new ACLEventSieve(session);
                sieve.siftEvents(events);
                AccessControlModifications<NodeId> mods = sieve.getModifications();
                if (!mods.getNodeIdentifiers().isEmpty()) {
                    this.notifyListeners(mods);
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to process access control modifications", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ACLEventSieve {
        private final Session session;
        private final String repPolicyName;
        private final Map<NodeId, Integer> modMap = new HashMap<NodeId, Integer>();

        public ACLEventSieve(Session session) throws RepositoryException {
            this.session = session;
            Name repPolicy = AccessControlConstants.N_POLICY;
            this.repPolicyName = session.getNamespacePrefix(repPolicy.getNamespaceURI()) + ":" + repPolicy.getLocalName();
        }

        public void siftEvents(EventIterator events) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    switch (event.getType()) {
                        case 1: {
                            this.siftNodeAdded(event.getIdentifier());
                            break;
                        }
                        case 2: {
                            this.siftNodeRemoved(event.getPath());
                            break;
                        }
                        case 16: {
                            this.siftPropertyChanged(event.getIdentifier());
                            break;
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to process ACL event: " + event, (Throwable)e);
                }
            }
        }

        public AccessControlModifications<NodeId> getModifications() {
            return new AccessControlModifications<NodeId>(this.modMap);
        }

        private void siftNodeAdded(String identifier) throws RepositoryException {
            try {
                NodeImpl n = (NodeImpl)this.session.getNodeByIdentifier(identifier);
                if (n.isNodeType(NT_REP_ACL)) {
                    this.addModification(this.accessControlledIdFromAclNode(n), 1);
                } else if (n.isNodeType(NT_REP_ACE)) {
                    this.addModification(this.accessControlledIdFromAceNode(n), 4);
                }
            }
            catch (ItemNotFoundException e) {
                log.debug("Cannot process NODE_ADDED event. Node {} doesn't exist (anymore).", (Object)identifier);
            }
        }

        private void siftNodeRemoved(String path) throws RepositoryException {
            String parentPath = Text.getRelativeParent(path, 1);
            if (this.session.nodeExists(parentPath)) {
                NodeImpl parent = (NodeImpl)this.session.getNode(parentPath);
                if (this.repPolicyName.equals(Text.getName(path))) {
                    this.addModification(parent.getNodeId(), 2);
                } else if (parent.isNodeType(NT_REP_ACL)) {
                    this.addModification(this.accessControlledIdFromAclNode(parent), 4);
                }
            } else {
                log.debug("Cannot process NODE_REMOVED event. Parent {} doesn't exist (anymore).", (Object)parentPath);
            }
        }

        private void siftPropertyChanged(String identifier) throws RepositoryException {
            try {
                NodeImpl parent = (NodeImpl)this.session.getNodeByIdentifier(identifier);
                if (parent.isNodeType(NT_REP_ACE)) {
                    this.addModification(this.accessControlledIdFromAceNode(parent), 4);
                }
            }
            catch (ItemNotFoundException e) {
                log.debug("Cannot process PROPERTY_CHANGED event. Node {} doesn't exist (anymore).", (Object)identifier);
            }
        }

        private NodeId accessControlledIdFromAclNode(Node aclNode) throws RepositoryException {
            return ((NodeImpl)aclNode.getParent()).getNodeId();
        }

        private NodeId accessControlledIdFromAceNode(Node aceNode) throws RepositoryException {
            return this.accessControlledIdFromAclNode(aceNode.getParent());
        }

        private void addModification(NodeId accessControllNodeId, int modType) {
            if (this.modMap.containsKey(accessControllNodeId)) {
                modType |= this.modMap.get(accessControllNodeId).intValue();
            }
            this.modMap.put(accessControllNodeId, modType);
        }
    }
}

