/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.conditions;

import java.util.Objects;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Validate {
    private static final Logger LOG = LoggerFactory.getLogger(Validate.class);
    private static final boolean CHECKMESSAGETEMPLATE = SystemPropertySupplier.create("oak.precondition.checks.CHECKMESSAGETEMPLATE", false).loggingTo(LOG).get();

    private Validate() {
    }

    public static void checkArgument(boolean expression) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @NotNull String message) throws IllegalArgumentException {
        Objects.requireNonNull(message);
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean expression, @NotNull String messageTemplate, Object ... messageArgs) {
        Objects.requireNonNull(messageTemplate);
        if (CHECKMESSAGETEMPLATE) {
            Validate.checkTemplate(messageTemplate, messageArgs);
        }
        if (!expression) {
            if (!CHECKMESSAGETEMPLATE) {
                Validate.checkTemplate(messageTemplate, messageArgs);
            }
            String message = String.format(messageTemplate, messageArgs);
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @NotNull Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @NotNull String messageTemplate, Object ... messageArgs) {
        Objects.requireNonNull(messageTemplate);
        if (CHECKMESSAGETEMPLATE) {
            Validate.checkTemplate(messageTemplate, messageArgs);
        }
        if (!expression) {
            if (!CHECKMESSAGETEMPLATE) {
                Validate.checkTemplate(messageTemplate, messageArgs);
            }
            String message = String.format(messageTemplate, messageArgs);
            throw new IllegalStateException(message);
        }
    }

    static boolean checkTemplate(@NotNull String messageTemplate, Object ... messageArgs) {
        boolean result;
        int argsSpecified = messageArgs.length;
        int argsInTemplate = Validate.countArguments(messageTemplate);
        boolean bl = result = argsSpecified == argsInTemplate;
        if (argsSpecified != argsInTemplate) {
            LOG.error("Invalid message format: template '{}', argument count {}", (Object)messageTemplate, (Object)argsSpecified);
        }
        return result;
    }

    static int countArguments(String template) {
        int count = 0;
        boolean inEscape = false;
        for (char c : template.toCharArray()) {
            if (inEscape) {
                if (c != '%') {
                    ++count;
                }
                inEscape = false;
                continue;
            }
            if (c != '%') continue;
            inEscape = true;
        }
        if (inEscape) {
            LOG.error("trailing escape character '%' found", (Throwable)new Exception("call stack"));
        }
        return count;
    }
}

