/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.error;

import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.storm.executor.error.IReportError;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportErrorAndDie
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReportErrorAndDie.class);
    private final IReportError reportError;
    private final Runnable suicideFn;

    public ReportErrorAndDie(IReportError reportError, Runnable suicideFn) {
        this.reportError = reportError;
        this.suicideFn = suicideFn;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            this.reportError.report(e);
        }
        catch (Exception ex) {
            LOG.error("Error while reporting error to cluster, proceeding with shutdown", (Throwable)ex);
        }
        if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, e) || Utils.exceptionCauseIsInstanceOf(InterruptedIOException.class, e) && !Utils.exceptionCauseIsInstanceOf(SocketTimeoutException.class, e)) {
            LOG.info("Got interrupted exception shutting thread down...");
        } else {
            this.suicideFn.run();
        }
    }
}

