/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.DefaultDirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.DirectedSubgraph;
import org.apache.storm.shade.org.jgrapht.traverse.TopologicalOrderIterator;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.trident.planner.BridgeReceiver;
import org.apache.storm.trident.planner.Node;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.ProcessorNode;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.TupleReceiver;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.topology.BatchInfo;
import org.apache.storm.trident.topology.ITridentBatchBolt;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.trident.util.IndexedEdge;
import org.apache.storm.trident.util.TridentUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;

public class SubtopologyBolt
implements ITridentBatchBolt {
    private static final long serialVersionUID = 1475508603138688412L;
    final DirectedGraph<Node, IndexedEdge> graph;
    final Set<Node> nodes;
    final Map<String, InitialReceiver> roots = new HashMap<String, InitialReceiver>();
    final Map<Node, TridentTuple.Factory> outputFactories = new HashMap<Node, TridentTuple.Factory>();
    final Map<String, List<TridentProcessor>> myTopologicallyOrdered = new HashMap<String, List<TridentProcessor>>();
    final Map<Node, String> batchGroups;

    public SubtopologyBolt(DefaultDirectedGraph<Node, IndexedEdge> graph, Set<Node> nodes, Map<Node, String> batchGroups) {
        this.nodes = nodes;
        this.graph = (DirectedGraph)graph.clone();
        this.batchGroups = SubtopologyBolt.copyAndOnlyKeep(batchGroups, nodes);
        HashSet<Node> nodesToKeep = new HashSet<Node>();
        for (IndexedEdge edge : this.graph.edgeSet()) {
            Node s = (Node)this.graph.getEdgeSource((Object)edge);
            Node t = (Node)this.graph.getEdgeTarget((Object)edge);
            if (!this.nodes.contains(s) && !this.nodes.contains(t)) continue;
            nodesToKeep.add(s);
            nodesToKeep.add(t);
        }
        HashSet nodesToRemove = new HashSet(this.graph.vertexSet());
        nodesToRemove.removeAll(nodesToKeep);
        this.graph.removeAllVertices(nodesToRemove);
    }

    private static Map<Node, String> copyAndOnlyKeep(Map<Node, String> batchGroups, Set<Node> nodes) {
        HashMap<Node, String> ret = new HashMap<Node, String>(nodes.size());
        for (Map.Entry<Node, String> entry : batchGroups.entrySet()) {
            if (!nodes.contains(entry.getKey())) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, BatchOutputCollector batchCollector) {
        int thisComponentNumTasks = context.getComponentTasks(context.getThisComponentId()).size();
        for (Node n : this.nodes) {
            if (n.stateInfo == null) continue;
            State s = n.stateInfo.spec.stateFactory.makeState(conf, context, context.getThisTaskIndex(), thisComponentNumTasks);
            context.setTaskData(n.stateInfo.id, s);
        }
        DirectedSubgraph subgraph = new DirectedSubgraph(this.graph, this.nodes, null);
        TopologicalOrderIterator it = new TopologicalOrderIterator((DirectedGraph)subgraph);
        int stateIndex = 0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n instanceof ProcessorNode) {
                ProcessorNode pn = (ProcessorNode)n;
                String batchGroup = this.batchGroups.get(n);
                if (!this.myTopologicallyOrdered.containsKey(batchGroup)) {
                    this.myTopologicallyOrdered.put(batchGroup, new ArrayList());
                }
                this.myTopologicallyOrdered.get(batchGroup).add(pn.processor);
                ArrayList<String> parentStreams = new ArrayList<String>();
                ArrayList<TridentTuple.Factory> parentFactories = new ArrayList<TridentTuple.Factory>();
                for (Node p : TridentUtils.getParents(this.graph, n)) {
                    parentStreams.add(p.streamId);
                    if (this.nodes.contains(p)) {
                        parentFactories.add(this.outputFactories.get(p));
                        continue;
                    }
                    if (!this.roots.containsKey(p.streamId)) {
                        this.roots.put(p.streamId, new InitialReceiver(p.streamId, this.getSourceOutputFields(context, p.streamId)));
                    }
                    this.roots.get(p.streamId).addReceiver(pn.processor);
                    parentFactories.add(this.roots.get(p.streamId).getOutputFactory());
                }
                ArrayList<TupleReceiver> targets = new ArrayList<TupleReceiver>();
                boolean outgoingNode = false;
                for (Node cn : TridentUtils.getChildren(this.graph, n)) {
                    if (this.nodes.contains(cn)) {
                        targets.add(((ProcessorNode)cn).processor);
                        continue;
                    }
                    outgoingNode = true;
                }
                if (outgoingNode) {
                    targets.add(new BridgeReceiver(batchCollector));
                }
                TridentContext triContext = new TridentContext(pn.selfOutFields, parentFactories, parentStreams, targets, pn.streamId, stateIndex, batchCollector);
                pn.processor.prepare(conf, context, triContext);
                this.outputFactories.put(n, pn.processor.getOutputFactory());
            }
            ++stateIndex;
        }
    }

    private Fields getSourceOutputFields(TopologyContext context, String sourceStream) {
        for (GlobalStreamId g : context.getThisSources().keySet()) {
            if (!g.get_streamId().equals(sourceStream)) continue;
            return context.getComponentOutputFields(g);
        }
        throw new RuntimeException("Could not find fields for source stream " + sourceStream);
    }

    @Override
    public void execute(BatchInfo batchInfo, Tuple tuple) {
        String sourceStream = tuple.getSourceStreamId();
        InitialReceiver ir = this.roots.get(sourceStream);
        if (ir == null) {
            throw new RuntimeException("Received unexpected tuple " + tuple.toString());
        }
        ir.receive((ProcessorContext)batchInfo.state, tuple);
    }

    @Override
    public void finishBatch(BatchInfo batchInfo) {
        for (TridentProcessor p : this.myTopologicallyOrdered.get(batchInfo.batchGroup)) {
            p.finishBatch((ProcessorContext)batchInfo.state);
        }
    }

    @Override
    public Object initBatchState(String batchGroup, Object batchId) {
        ProcessorContext ret = new ProcessorContext(batchId, new Object[this.nodes.size()]);
        for (TridentProcessor p : this.myTopologicallyOrdered.get(batchGroup)) {
            p.startBatch(ret);
        }
        return ret;
    }

    @Override
    public void cleanup() {
        for (String bg : this.myTopologicallyOrdered.keySet()) {
            for (TridentProcessor p : this.myTopologicallyOrdered.get(bg)) {
                p.cleanup();
            }
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (Node n : this.nodes) {
            declarer.declareStream(n.streamId, TridentUtils.fieldsConcat(new Fields("$batchId"), n.allOutputFields));
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    protected static class InitialReceiver {
        List<TridentProcessor> receivers = new ArrayList<TridentProcessor>();
        TridentTupleView.RootFactory factory;
        TridentTupleView.ProjectionFactory project;
        String stream;

        public InitialReceiver(String stream, Fields allFields) {
            this.stream = stream;
            this.factory = new TridentTupleView.RootFactory(allFields);
            ArrayList<String> projected = new ArrayList<String>(allFields.toList());
            projected.remove(0);
            this.project = new TridentTupleView.ProjectionFactory(this.factory, new Fields(projected));
        }

        public void receive(ProcessorContext context, Tuple tuple) {
            TridentTuple t = this.project.create(this.factory.create(tuple));
            for (TridentProcessor r : this.receivers) {
                r.execute(context, this.stream, t);
            }
        }

        public void addReceiver(TridentProcessor p) {
            this.receivers.add(p);
        }

        public TridentTuple.Factory getOutputFactory() {
            return this.project;
        }
    }
}

