/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.container.cgroup.CgroupUtils;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;

public class CpuacctCore
implements CgroupCore {
    public static final String CPUACCT_USAGE = "/cpuacct.usage";
    public static final String CPUACCT_STAT = "/cpuacct.stat";
    public static final String CPUACCT_USAGE_PERCPU = "/cpuacct.usage_percpu";
    private final String dir;

    public CpuacctCore(String dir) {
        this.dir = dir;
    }

    @Override
    public SubSystemType getType() {
        return SubSystemType.cpuacct;
    }

    public Long getCpuUsage() throws IOException {
        return Long.parseLong(CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, CPUACCT_USAGE)).get(0));
    }

    public Map<StatType, Long> getCpuStat() throws IOException {
        List<String> strs = CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, CPUACCT_STAT));
        HashMap<StatType, Long> result2 = new HashMap<StatType, Long>();
        result2.put(StatType.user, Long.parseLong(strs.get(0).split(" ")[1]));
        result2.put(StatType.system, Long.parseLong(strs.get(1).split(" ")[1]));
        return result2;
    }

    public Long[] getPerCpuUsage() throws IOException {
        String str = CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, CPUACCT_USAGE_PERCPU)).get(0);
        String[] strArgs = str.split(" ");
        Long[] result2 = new Long[strArgs.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = Long.parseLong(strArgs[i]);
        }
        return result2;
    }

    public static enum StatType {
        user,
        system;

    }
}

