/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.trident.state.ITupleCollection;
import org.apache.storm.trident.state.OpaqueValue;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.state.map.OpaqueMap;
import org.apache.storm.trident.state.map.SnapshottableMap;
import org.apache.storm.trident.state.snapshot.Snapshottable;
import org.apache.storm.trident.util.LRUMap;
import org.apache.storm.tuple.Values;

public class LRUMemoryMapState<T>
implements Snapshottable<T>,
ITupleCollection,
MapState<T> {
    static ConcurrentHashMap<String, Map<List<Object>, Object>> dbs = new ConcurrentHashMap();
    LRUMemoryMapStateBacking<OpaqueValue> backing;
    SnapshottableMap<T> delegate;

    public LRUMemoryMapState(int cacheSize, String id) {
        this.backing = new LRUMemoryMapStateBacking(cacheSize, id);
        this.delegate = new SnapshottableMap(OpaqueMap.build(this.backing), new Values("$MEMORY-MAP-STATE-GLOBAL$"));
    }

    @Override
    public T update(ValueUpdater updater) {
        return this.delegate.update(updater);
    }

    @Override
    public void set(T o) {
        this.delegate.set(o);
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public void beginCommit(Long txid) {
        this.delegate.beginCommit(txid);
    }

    @Override
    public void commit(Long txid) {
        this.delegate.commit(txid);
    }

    @Override
    public Iterator<List<Object>> getTuples() {
        return this.backing.getTuples();
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        return this.delegate.multiUpdate(keys, updaters);
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this.delegate.multiPut(keys, vals);
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        return this.delegate.multiGet(keys);
    }

    static class LRUMemoryMapStateBacking<T>
    implements IBackingMap<T>,
    ITupleCollection {
        Map<List<Object>, T> db;
        Long currTx;

        LRUMemoryMapStateBacking(int cacheSize, String id) {
            if (!dbs.containsKey(id)) {
                dbs.put(id, new LRUMap(cacheSize));
            }
            this.db = dbs.get(id);
        }

        public static void clearAll() {
            dbs.clear();
        }

        @Override
        public List<T> multiGet(List<List<Object>> keys) {
            ArrayList<T> ret = new ArrayList<T>();
            for (List<Object> key : keys) {
                ret.add(this.db.get(key));
            }
            return ret;
        }

        @Override
        public void multiPut(List<List<Object>> keys, List<T> vals) {
            for (int i = 0; i < keys.size(); ++i) {
                List<Object> key = keys.get(i);
                T val = vals.get(i);
                this.db.put(key, val);
            }
        }

        @Override
        public Iterator<List<Object>> getTuples() {
            return new Iterator<List<Object>>(){
                private Iterator<Map.Entry<List<Object>, T>> it;
                {
                    this.it = db.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public List<Object> next() {
                    Map.Entry e = this.it.next();
                    ArrayList<Object> ret = new ArrayList<Object>();
                    ret.addAll((Collection)e.getKey());
                    ret.add(((OpaqueValue)e.getValue()).getCurr());
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    public static class Factory
    implements StateFactory {
        String id = UUID.randomUUID().toString();
        int maxSize;

        public Factory(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public State makeState(Map<String, Object> conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new LRUMemoryMapState(this.maxSize, this.id + partitionIndex);
        }
    }
}

