/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsUserSourceImpl
implements MetricsUserSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUserSourceImpl.class);
    private final String userNamePrefix;
    private final String user;
    private final String userGetKey;
    private final String userScanTimeKey;
    private final String userPutKey;
    private final String userDeleteKey;
    private final String userIncrementKey;
    private final String userAppendKey;
    private final String userReplayKey;
    private final String userBlockBytesScannedKey;
    private MetricHistogram getHisto;
    private MetricHistogram scanTimeHisto;
    private MetricHistogram putHisto;
    private MetricHistogram deleteHisto;
    private MetricHistogram incrementHisto;
    private MetricHistogram appendHisto;
    private MetricHistogram replayHisto;
    private MutableFastCounter blockBytesScannedCount;
    private final int hashCode;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final DynamicMetricsRegistry registry;
    private ConcurrentHashMap<String, MetricsUserSource.ClientMetrics> clientMetricsMap;

    public MetricsUserSourceImpl(String user, MetricsUserAggregateSourceImpl agg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new MetricsUserSourceImpl for user " + user);
        }
        this.user = user;
        this.registry = agg.getMetricsRegistry();
        this.userNamePrefix = "User_" + user + "_metric_";
        this.hashCode = this.userNamePrefix.hashCode();
        this.userGetKey = this.userNamePrefix + "get";
        this.userScanTimeKey = this.userNamePrefix + "scanTime";
        this.userPutKey = this.userNamePrefix + "put";
        this.userDeleteKey = this.userNamePrefix + "delete";
        this.userIncrementKey = this.userNamePrefix + "increment";
        this.userAppendKey = this.userNamePrefix + "append";
        this.userReplayKey = this.userNamePrefix + "replay";
        this.userBlockBytesScannedKey = this.userNamePrefix + "blockBytesScannedCount";
        this.clientMetricsMap = new ConcurrentHashMap();
        agg.register(this);
    }

    public void register() {
        this.getHisto = this.registry.newTimeHistogram(this.userGetKey);
        this.scanTimeHisto = this.registry.newTimeHistogram(this.userScanTimeKey);
        this.putHisto = this.registry.newTimeHistogram(this.userPutKey);
        this.deleteHisto = this.registry.newTimeHistogram(this.userDeleteKey);
        this.incrementHisto = this.registry.newTimeHistogram(this.userIncrementKey);
        this.appendHisto = this.registry.newTimeHistogram(this.userAppendKey);
        this.replayHisto = this.registry.newTimeHistogram(this.userReplayKey);
        this.blockBytesScannedCount = this.registry.newCounter(this.userBlockBytesScannedKey, "", 0L);
    }

    public void deregister() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing user Metrics for user: " + this.user);
        }
        this.registry.removeMetric(this.userGetKey);
        this.registry.removeMetric(this.userScanTimeKey);
        this.registry.removeMetric(this.userPutKey);
        this.registry.removeMetric(this.userDeleteKey);
        this.registry.removeMetric(this.userIncrementKey);
        this.registry.removeMetric(this.userAppendKey);
        this.registry.removeMetric(this.userReplayKey);
        this.registry.removeMetric(this.userBlockBytesScannedKey);
    }

    public String getUser() {
        return this.user;
    }

    public int compareTo(MetricsUserSource source) {
        if (source == null) {
            return -1;
        }
        if (!(source instanceof MetricsUserSourceImpl)) {
            return -1;
        }
        MetricsUserSourceImpl impl = (MetricsUserSourceImpl)source;
        return Long.compare(this.hashCode, impl.hashCode);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MetricsUserSourceImpl && this.compareTo((MetricsUserSourceImpl)obj) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsUserSourceImpl metricsUserSourceImpl = this;
        synchronized (metricsUserSourceImpl) {
            if (this.closed.get()) {
                return;
            }
        }
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long time, long blockBytesScanned) {
        this.getHisto.add(time);
        this.blockBytesScannedCount.incr(blockBytesScanned);
    }

    public void updateIncrement(long time, long blockBytesScanned) {
        this.incrementHisto.add(time);
        this.blockBytesScannedCount.incr(blockBytesScanned);
    }

    public void updateAppend(long time, long blockBytesScanned) {
        this.appendHisto.add(time);
        this.blockBytesScannedCount.incr(blockBytesScanned);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void updateScan(long time, long blockBytesScanned) {
        this.scanTimeHisto.add(time);
        this.blockBytesScannedCount.incr(blockBytesScanned);
    }

    public void updateCheckAndMutate(long blockBytesScanned) {
        this.blockBytesScannedCount.incr(blockBytesScanned);
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.userNamePrefix);
        this.registry.snapshot(mrb, all);
    }

    public Map<String, MetricsUserSource.ClientMetrics> getClientMetrics() {
        return Collections.unmodifiableMap(this.clientMetricsMap);
    }

    public MetricsUserSource.ClientMetrics getOrCreateMetricsClient(String client) {
        MetricsUserSource.ClientMetrics source = this.clientMetricsMap.get(client);
        if (source != null) {
            return source;
        }
        source = new ClientMetricsImpl(client);
        MetricsUserSource.ClientMetrics prev = this.clientMetricsMap.putIfAbsent(client, source);
        if (prev != null) {
            return prev;
        }
        return source;
    }

    static class ClientMetricsImpl
    implements MetricsUserSource.ClientMetrics {
        private final String hostName;
        final LongAdder readRequestsCount = new LongAdder();
        final LongAdder writeRequestsCount = new LongAdder();
        final LongAdder filteredRequestsCount = new LongAdder();

        public ClientMetricsImpl(String hostName) {
            this.hostName = hostName;
        }

        public void incrementReadRequest() {
            this.readRequestsCount.increment();
        }

        public void incrementWriteRequest() {
            this.writeRequestsCount.increment();
        }

        public String getHostName() {
            return this.hostName;
        }

        public long getReadRequestsCount() {
            return this.readRequestsCount.sum();
        }

        public long getWriteRequestsCount() {
            return this.writeRequestsCount.sum();
        }

        public void incrementFilteredReadRequests() {
            this.filteredRequestsCount.increment();
        }

        public long getFilteredReadRequests() {
            return this.filteredRequestsCount.sum();
        }
    }
}

