/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.transconsole.common.messages.InvalidMessageException;
import java.util.Set;
import java.util.TreeSet;

final class MessageProperties {
    private String contentType;
    private String description;
    private String meaning;
    private String name;
    private final Set<String> sources;
    private boolean isHidden;
    private boolean isObsolete;

    public MessageProperties() {
        this.contentType = null;
        this.description = null;
        this.name = null;
        this.sources = Sets.newTreeSet();
        this.meaning = null;
        this.isHidden = false;
        this.isObsolete = false;
    }

    private MessageProperties(String contentType, String description, String meaning, String name, Set<String> sources, boolean isHidden, boolean isObsolete) {
        this.contentType = contentType;
        this.description = description;
        this.name = name;
        this.sources = sources;
        this.meaning = meaning;
        this.isHidden = isHidden;
        this.isObsolete = isObsolete;
    }

    protected MessageProperties(MessageProperties original) {
        this.contentType = original.contentType;
        this.description = original.description;
        this.name = original.name;
        this.sources = Sets.newTreeSet(original.sources);
        this.meaning = original.meaning;
        this.isHidden = original.isHidden;
        this.isObsolete = original.isObsolete;
    }

    protected void setContentType(String contentType) {
        this.contentType = Preconditions.checkNotNull(contentType);
    }

    public String getContentType() {
        return this.contentType;
    }

    protected void setDescription(String description) {
        this.description = Preconditions.checkNotNull(description);
    }

    public String getDescription() {
        return this.description;
    }

    protected void setMeaning(String meaning) {
        this.meaning = meaning;
    }

    public String getMeaning() {
        return this.meaning;
    }

    protected void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setObsolete(boolean obsolete) {
        this.isObsolete = obsolete;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void addSource(String source) {
        this.sources.add(source);
    }

    public Set<String> getSources() {
        return this.sources;
    }

    MessageProperties merge(MessageProperties that) throws InvalidMessageException {
        String mergedName;
        String mergedDescription;
        String mergedContentType = this.contentType;
        if (!Objects.equal(this.contentType, that.contentType)) {
            try {
                throw new InvalidMessageException("Cannot merge messages with incompatible content-types.");
            }
            catch (InvalidMessageException e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (Objects.equal(this.description, that.description) || that.description == null || that.description.trim().length() == 0) {
            mergedDescription = this.description;
        } else if (this.description == null || this.description.trim().length() == 0) {
            mergedDescription = that.description;
        } else {
            throw new InvalidMessageException("Cannot merge messages with incompatible descriptions.");
        }
        if (!Objects.equal(this.meaning, that.meaning)) {
            throw new InvalidMessageException("Cannot merge messages with different meanings.");
        }
        String mergedMeaning = this.meaning;
        if (Objects.equal(this.name, that.name) || that.name == null) {
            mergedName = this.name;
        } else if (this.name == null) {
            mergedName = that.name;
        } else {
            throw new InvalidMessageException("Cannot merge messages with different names.");
        }
        TreeSet<String> mergedSources = Sets.newTreeSet();
        mergedSources.addAll(this.sources);
        mergedSources.addAll(that.sources);
        boolean mergedIsHidden = this.isHidden && that.isHidden;
        boolean mergedIsObsolete = this.isObsolete && that.isObsolete;
        return new MessageProperties(mergedContentType, mergedDescription, mergedMeaning, mergedName, mergedSources, mergedIsHidden, mergedIsObsolete);
    }

    public int hashCode() {
        return Objects.hashCode(this.contentType, this.description, this.meaning, this.name, this.sources, this.isHidden, this.isObsolete);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MessageProperties)) {
            return false;
        }
        MessageProperties otherProperties = (MessageProperties)other;
        return Objects.equal(this.contentType, otherProperties.contentType) && Objects.equal(this.description, otherProperties.description) && Objects.equal(this.meaning, otherProperties.meaning) && Objects.equal(this.name, otherProperties.name) && Objects.equal(this.sources, otherProperties.sources) && Objects.equal(this.isHidden, otherProperties.isHidden) && Objects.equal(this.isObsolete, otherProperties.isObsolete);
    }
}

