/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.FrameReader;
import org.apache.sysml.runtime.io.FrameReaderFactory;
import org.apache.sysml.runtime.io.FrameWriter;
import org.apache.sysml.runtime.io.FrameWriterFactory;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.UtilFunctions;

public class FrameObject
extends CacheableData<FrameBlock> {
    private static final long serialVersionUID = 1755082174281927785L;
    private Expression.ValueType[] _schema = null;

    protected FrameObject() {
        super(Expression.DataType.FRAME, Expression.ValueType.STRING);
    }

    public FrameObject(String fname) {
        this();
        this.setFileName(fname);
    }

    public FrameObject(String fname, MetaData meta) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
    }

    public FrameObject(String fname, MetaData meta, Expression.ValueType[] schema) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
        this.setSchema(schema);
    }

    public FrameObject(FrameObject fo) {
        super(fo);
    }

    @Override
    public Expression.ValueType[] getSchema() {
        return this._schema;
    }

    public Expression.ValueType[] getSchema(int cl, int cu) {
        return this._schema != null && this._schema.length > cu ? Arrays.copyOfRange(this._schema, cl, cu + 1) : UtilFunctions.nCopies(cu - cl + 1, Expression.ValueType.STRING);
    }

    public Expression.ValueType[] mergeSchemas(FrameObject fo) {
        return (Expression.ValueType[])ArrayUtils.addAll((Object[])(this._schema != null ? this._schema : UtilFunctions.nCopies((int)this.getNumColumns(), Expression.ValueType.STRING)), (Object[])(fo._schema != null ? fo._schema : UtilFunctions.nCopies((int)fo.getNumColumns(), Expression.ValueType.STRING)));
    }

    public void setSchema(String schema) {
        if (schema.equals("*")) {
            int clen = (int)this.getNumColumns();
            if (clen >= 0) {
                this._schema = UtilFunctions.nCopies(clen, Expression.ValueType.STRING);
            }
        } else {
            String[] parts = schema.split(",");
            this._schema = new Expression.ValueType[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                this._schema[i] = Expression.ValueType.valueOf(parts[i].toUpperCase());
            }
        }
    }

    public void setSchema(Expression.ValueType[] schema) {
        this._schema = schema;
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        MatrixCharacteristics mc = this._metaData.getMatrixCharacteristics();
        mc.setDimension(((FrameBlock)this._data).getNumRows(), ((FrameBlock)this._data).getNumColumns());
        mc.setNonZeros(((FrameBlock)this._data).getNumRows() * ((FrameBlock)this._data).getNumColumns());
        this._schema = ((FrameBlock)this._data).getSchema();
    }

    public long getNumRows() {
        MatrixCharacteristics mc = this.getMatrixCharacteristics();
        return mc.getRows();
    }

    public long getNumColumns() {
        MatrixCharacteristics mc = this.getMatrixCharacteristics();
        return mc.getCols();
    }

    @Override
    protected FrameBlock readBlobFromCache(String fname) throws IOException {
        return (FrameBlock)LazyWriteBuffer.readBlock(fname, false);
    }

    @Override
    protected FrameBlock readBlobFromHDFS(String fname, long rlen, long clen) throws IOException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        Expression.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1L ? (int)clen : 1, Expression.ValueType.STRING);
        FrameBlock data = null;
        try {
            FrameReader reader = FrameReaderFactory.createFrameReader(iimd.getInputInfo(), this.getFileFormatProperties());
            data = reader.readFrameFromHDFS(fname, lschema, mc.getRows(), mc.getCols());
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (data == null) {
            throw new IOException("Unable to load frame from file: " + fname);
        }
        return data;
    }

    @Override
    protected FrameBlock readBlobFromRDD(RDDObject rdd, MutableBoolean status) throws IOException {
        RDDObject lrdd = rdd;
        status.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        int rlen = (int)mc.getRows();
        int clen = (int)mc.getCols();
        Expression.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1 ? clen : 1, Expression.ValueType.STRING);
        FrameBlock fb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            fb = SparkExecutionContext.toFrameBlock(lrdd, lschema, rlen, clen);
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (fb == null) {
            throw new IOException("Unable to load frame from rdd.");
        }
        return fb;
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        OutputInfo oinfo = OutputInfo.stringToOutputInfo(ofmt);
        FrameWriter writer = FrameWriterFactory.createFrameWriter(oinfo, fprop);
        writer.writeFrameToHDFS((FrameBlock)this._data, fname, this.getNumRows(), this.getNumColumns());
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String ofmt) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        OutputInfo oinfo = ofmt != null ? OutputInfo.stringToOutputInfo(ofmt) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        SparkExecutionContext.writeFrameRDDtoHDFS(rdd, fname, oinfo);
    }
}

