/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.matrix.data.LibMatrixCountDistinct;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;

public class CompressedSizeEstimatorUltraSparse
extends CompressedSizeEstimator {
    final int nDistinct;
    final EstimationFactors oneColumnFacts;

    private CompressedSizeEstimatorUltraSparse(MatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
        CountDistinctOperator op = new CountDistinctOperator(CountDistinctOperator.CountDistinctTypes.COUNT);
        int _numRows = this.getNumRows();
        if (LOG.isDebugEnabled()) {
            Timing time = new Timing(true);
            this.nDistinct = LibMatrixCountDistinct.estimateDistinctValues(data, op);
            LOG.debug((Object)("Number Distinct found in entire matrix: " + this.nDistinct + "  [ms]: " + time.stop()));
        } else {
            this.nDistinct = LibMatrixCountDistinct.estimateDistinctValues(data, op);
        }
        double sparsity = data.getSparsity();
        int largestOff = (int)((double)_numRows * (1.0 - sparsity));
        this.oneColumnFacts = new EstimationFactors(1, this.nDistinct, _numRows, largestOff, sparsity);
    }

    protected static CompressedSizeEstimatorUltraSparse create(MatrixBlock data, CompressionSettings compSettings, int k) {
        LOG.debug((Object)"Using UltraSparse Estimator");
        long oldNNZ = data.getNonZeros();
        if (LOG.isDebugEnabled()) {
            Timing time = new Timing(true);
            data = LibMatrixReorg.transpose(data, new MatrixBlock(data.getNumColumns(), data.getNumRows(), true), k, true);
            LOG.debug((Object)("Transposing Input for Ultra Sparse: " + time.stop()));
        } else {
            data = LibMatrixReorg.transpose(data, new MatrixBlock(data.getNumColumns(), data.getNumRows(), true), k, true);
        }
        data.setNonZeros(oldNNZ);
        compSettings.transposed = true;
        return new CompressedSizeEstimatorUltraSparse(data, compSettings);
    }

    @Override
    protected CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen, int k) {
        return this.CompressedSizeInfoColGroup(clen);
    }

    @Override
    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes, int estimate, int nrUniqueUpperBound) {
        int _numRows = this.getNumRows();
        if (colIndexes.length == 1) {
            return new CompressedSizeInfoColGroup(colIndexes, this.oneColumnFacts, this._data.getSparsity());
        }
        double sparsity = this._data.getSparsity();
        int nCols = colIndexes.length;
        int scaledDistinct = (int)Math.min(Math.pow(this.nDistinct, nCols), 2.147483647E9);
        int largestOff = (int)((double)_numRows * (1.0 - sparsity * (double)nCols));
        EstimationFactors facts = new EstimationFactors(nCols, scaledDistinct, _numRows, largestOff, sparsity);
        return new CompressedSizeInfoColGroup(colIndexes, facts, this._data.getSparsity());
    }

    @Override
    protected CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] joined, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int joinedMaxDistinct) {
        throw new NotImplementedException();
    }

    @Override
    protected int worstCaseUpperBound(int[] columns) {
        return this.getNumRows();
    }
}

