/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.ApplicationStateContribution;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategySource;

public class ApplicationStateManagerImpl
implements ApplicationStateManager {
    static final String DEFAULT_STRATEGY = "session";
    private final Map<Class, ApplicationStateAdapter> classToAdapter = CollectionFactory.newConcurrentMap();
    private final ApplicationStatePersistenceStrategySource source;
    private final ObjectLocator locator;

    public ApplicationStateManagerImpl(Map<Class, ApplicationStateContribution> configuration, ApplicationStatePersistenceStrategySource source, ObjectLocator locator) {
        this.source = source;
        this.locator = locator;
        for (Class asoClass : configuration.keySet()) {
            ApplicationStateContribution contribution = configuration.get(asoClass);
            ApplicationStateAdapter adapter = this.newAdapter(asoClass, contribution.getStrategy(), contribution.getCreator());
            this.classToAdapter.put(asoClass, adapter);
        }
    }

    private <T> ApplicationStateAdapter<T> newAdapter(final Class<T> ssoClass, String strategyName, ApplicationStateCreator<T> creator) {
        if (creator == null) {
            creator = new ApplicationStateCreator<T>(){

                @Override
                public T create() {
                    return ApplicationStateManagerImpl.this.locator.autobuild("Instantiating instance of SSO class " + ssoClass.getName(), ssoClass);
                }
            };
        }
        ApplicationStatePersistenceStrategy strategy = this.source.get(strategyName);
        return new ApplicationStateAdapter<T>(ssoClass, strategy, creator);
    }

    private <T> ApplicationStateAdapter<T> getAdapter(Class<T> ssoClass) {
        ApplicationStateAdapter<T> result = this.classToAdapter.get(ssoClass);
        if (result == null) {
            result = this.newAdapter(ssoClass, DEFAULT_STRATEGY, null);
            this.classToAdapter.put(ssoClass, result);
        }
        return result;
    }

    @Override
    public <T> T get(Class<T> ssoClass) {
        return this.getAdapter(ssoClass).getOrCreate();
    }

    @Override
    public <T> T getIfExists(Class<T> ssoClass) {
        return this.getAdapter(ssoClass).getIfExists();
    }

    @Override
    public <T> void set(Class<T> ssoClass, T sso) {
        this.getAdapter(ssoClass).set(sso);
    }

    @Override
    public <T> boolean exists(Class<T> ssoClass) {
        return this.getAdapter(ssoClass).exists();
    }

    static class ApplicationStateAdapter<T> {
        private final Class<T> ssoClass;
        private final ApplicationStatePersistenceStrategy strategy;
        private final ApplicationStateCreator<T> creator;

        ApplicationStateAdapter(Class<T> ssoClass, ApplicationStatePersistenceStrategy strategy, ApplicationStateCreator<T> creator) {
            this.ssoClass = ssoClass;
            this.strategy = strategy;
            this.creator = creator;
        }

        T getOrCreate() {
            return this.strategy.get(this.ssoClass, this.creator);
        }

        void set(T sso) {
            this.strategy.set(this.ssoClass, sso);
        }

        boolean exists() {
            return this.strategy.exists(this.ssoClass);
        }

        T getIfExists() {
            return this.strategy.getIfExists(this.ssoClass);
        }
    }
}

