/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.StrategyRegistry;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.ValueEncoderFactory;
import org.apache.tapestry5.services.ValueEncoderSource;

public class ValueEncoderSourceImpl
implements ValueEncoderSource,
Runnable {
    private final StrategyRegistry<ValueEncoderFactory> registry;
    private final Map<Class, ValueEncoder> cache = CollectionFactory.newConcurrentMap();

    public ValueEncoderSourceImpl(Map<Class, ValueEncoderFactory> configuration) {
        this.registry = StrategyRegistry.newInstance(ValueEncoderFactory.class, configuration);
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub hub) {
        hub.addInvalidationCallback((Runnable)this);
    }

    @Override
    public <T> ValueEncoder<T> getValueEncoder(Class<T> type) {
        assert (type != null);
        ValueEncoder<T> result = this.cache.get(type);
        if (result == null) {
            ValueEncoderFactory factory = (ValueEncoderFactory)this.registry.get(type);
            result = factory.create(type);
            this.cache.put(type, result);
        }
        return result;
    }

    @Override
    public void run() {
        this.registry.clearCache();
        this.cache.clear();
    }
}

